/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.WeldLogger;

@MessageLogger(projectCode="WELD-")
public interface BootstrapLogger
extends WeldLogger {
    public static final BootstrapLogger LOG = Logger.getMessageLogger(BootstrapLogger.class, Category.BOOTSTRAP.getName());

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=100, value="Weld initialized. Validating beans")
    public void validatingBeans();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=101, value="Transactional services not available. Injection of @Inject UserTransaction not available. Transactional observers will be invoked synchronously.")
    public void jtaUnavailable();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=103, value="Enabled alternatives for {0}: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void enabledAlternatives(Object var1, Object var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=104, value="Enabled decorator types for {0}: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void enabledDecorators(Object var1, Object var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=105, value="Enabled interceptor types for {0}: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void enabledInterceptors(Object var1, Object var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=106, value="Bean: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void foundBean(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=107, value="Interceptor: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void foundInterceptor(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=108, value="Decorator: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void foundDecorator(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=109, value="ObserverMethod: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void foundObserverMethod(Object var1);

    @Message(id=110, value="Cannot set the annotation type to null (if you want to stop the type being used, call veto()):  {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException annotationTypeNull(Object var1);

    @Message(id=111, value="Bean type is not STATELESS, STATEFUL or SINGLETON:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException beanTypeNotEjb(Object var1);

    @Message(id=112, value="Class {0} has both @Interceptor and @Decorator annotations", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException beanIsBothInterceptorAndDecorator(Object var1);

    @Message(id=113, value="BeanDeploymentArchive must not be null:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException deploymentArchiveNull(Object var1);

    @Message(id=114, value="Must start the container with a deployment")
    public IllegalArgumentException deploymentRequired();

    @Message(id=116, value="Manager has not been initialized")
    public IllegalStateException managerNotInitialized();

    @Message(id=117, value="Required service {0} has not been specified", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unspecifiedRequiredService(Object var1);

    @Message(id=118, value="Only normal scopes can be passivating. Scope {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException passivatingNonNormalScopeIllegal(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=119, value="Not generating any bean definitions from {0} because of underlying class loading error: Type {1} not found.  If this is unexpected, enable DEBUG logging to see the full error.", format=Message.Format.MESSAGE_FORMAT)
    public void ignoringClassDueToLoadingError(Object var1, Object var2);

    @Message(id=123, value="Error loading {0} defined in {1}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException errorLoadingBeansXmlEntry(Object var1, Object var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=124, value="Using {0} threads for bootstrap", format=Message.Format.MESSAGE_FORMAT)
    public void threadsInUse(Object var1);

    @Message(id=125, value="Invalid thread pool size: {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException invalidThreadPoolSize(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=126, value="Timeout shutting down thread pool {0} at {1}", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutShuttingDownThreadPool(Object var1, Object var2);

    @Message(id=127, value="Invalid thread pool type: {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException invalidThreadPoolType(Object var1);

    @Message(id=128, value="Invalid value for property {0}: {1}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException invalidPropertyValue(Object var1, Object var2);

    @Message(id=130, value="Cannot replace AnnotatedType for {0} with AnnotatedType for {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException annotatedTypeJavaClassMismatch(Object var1, Object var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=132, value="Disabled alternative (ignored): {0}", format=Message.Format.MESSAGE_FORMAT)
    public void foundDisabledAlternative(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=133, value="Specialized bean (ignored): {0}", format=Message.Format.MESSAGE_FORMAT)
    public void foundSpecializedBean(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=134, value="Producer (method or field) of specialized bean (ignored): {0}", format=Message.Format.MESSAGE_FORMAT)
    public void foundProducerOfSpecializedBean(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=135, value="Legacy deployment metadata provided by the integrator. Certain functionality will not be available.")
    public void legacyDeploymentMetadataProvided();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=136, value="Exception(s) thrown during observer of BeforeShutdown: ")
    public void exceptionThrownDuringBeforeShutdownObserver();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=137, value="Exception while loading class '{0}' : {1}", format=Message.Format.MESSAGE_FORMAT)
    public void exceptionWhileLoadingClass(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=138, value="Error while loading class '{0}' : {1}", format=Message.Format.MESSAGE_FORMAT)
    public void errorWhileLoadingClass(Object var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=139, value="Ignoring portable extension class {0} because of underlying class loading error: Type {1} not found. Enable DEBUG logging level to see the full error.", format=Message.Format.MESSAGE_FORMAT)
    public void ignoringExtensionClassDueToLoadingError(String var1, String var2);

    @Message(id=140, value="Calling Bootstrap method after container has already been initialized. For correct order, see CDI11Bootstrap's documentation.")
    public IllegalStateException callingBootstrapMethodAfterContainerHasBeenInitialized();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=141, value="Falling back to the default observer method resolver due to {0}", format=Message.Format.MESSAGE_FORMAT)
    public void notUsingFastResolver(ObserverMethod<?> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=142, value="Exception loading annotated type using ClassFileServices. Falling back to the default implementation. {0}", format=Message.Format.MESSAGE_FORMAT)
    public void exceptionLoadingAnnotatedType(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=0, value="No PAT observers resolved for {0}. Skipping.", format=Message.Format.MESSAGE_FORMAT)
    public void patSkipped(SlimAnnotatedType<?> var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=0, value="Sending PAT using the default event resolver: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void patDefaultResolver(SlimAnnotatedType<?> var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=0, value="Sending PAT using the fast event resolver: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void patFastResolver(SlimAnnotatedType<?> var1);

    @Message(id=143, value="Container lifecycle event method invoked outside of extension observer method invocation.")
    public IllegalStateException containerLifecycleEventMethodInvokedOutsideObserver();

    @Message(id=144, value="CDI API version mismatch. CDI 1.0 API detected on classpath. Weld requires version 1.1 or better.")
    public IllegalStateException cdiApiVersionMismatch();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=145, value="Bean identifier index built:\n  {0}", format=Message.Format.MESSAGE_FORMAT)
    public void beanIdentifierIndexBuilt(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=146, value="BeforeBeanDiscovery.addAnnotatedType(AnnotatedType<?>) used for {0} is deprecated from CDI 1.1!", format=Message.Format.MESSAGE_FORMAT)
    public void deprecatedAddAnnotatedTypeMethodUsed(Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=147, value="Decorator {0} declares inappropriate constructor therefore will not available as a managed bean!", format=Message.Format.MESSAGE_FORMAT)
    public void decoratorWithNonCdiConstructor(String var1);
}

