/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bootstrap.events.BeforeShutdownImpl;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.context.ApplicationContext;
import org.jboss.weld.context.SingletonContext;
import org.jboss.weld.manager.BeanManagerImpl;

public class WeldRuntime {
    private BeanManagerImpl deploymentManager;
    private ConcurrentMap<BeanDeploymentArchive, BeanManagerImpl> bdaToBeanManagerMap;
    private String contextId;

    public WeldRuntime(String contextId, BeanManagerImpl deploymentManager, ConcurrentMap<BeanDeploymentArchive, BeanManagerImpl> bdaToBeanManagerMap) {
        this.contextId = contextId;
        this.deploymentManager = deploymentManager;
        this.bdaToBeanManagerMap = bdaToBeanManagerMap;
    }

    public BeanManagerImpl getManager(BeanDeploymentArchive beanDeploymentArchive) {
        return (BeanManagerImpl)this.bdaToBeanManagerMap.get(beanDeploymentArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            ((ApplicationContext)this.deploymentManager.instance().select(ApplicationContext.class, new Annotation[0]).get()).invalidate();
            ((SingletonContext)this.deploymentManager.instance().select(SingletonContext.class, new Annotation[0]).get()).invalidate();
        }
        finally {
            try {
                BeforeShutdownImpl.fire(this.deploymentManager);
            }
            finally {
                Container container = Container.instance(this.contextId);
                container.setState(ContainerState.SHUTDOWN);
                container.cleanup();
            }
        }
    }
}

