/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.injection.producer.AbstractProducer;
import org.jboss.weld.injection.producer.DefaultInjector;
import org.jboss.weld.injection.producer.DefaultInstantiator;
import org.jboss.weld.injection.producer.DefaultLifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.Injector;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.NoopLifecycleCallbackInvoker;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;

public class BasicInjectionTarget<T>
extends AbstractProducer<T>
implements WeldInjectionTarget<T> {
    protected final BeanManagerImpl beanManager;
    private final SlimAnnotatedType<T> type;
    private final Set<InjectionPoint> injectionPoints;
    private Instantiator<T> instantiator;
    private final Injector<T> injector;
    private final LifecycleCallbackInvoker<T> invoker;

    public static <T> BasicInjectionTarget<T> create(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager, Injector<T> injector, LifecycleCallbackInvoker<T> invoker) {
        return new BasicInjectionTarget<T>(type, bean, beanManager, injector, invoker);
    }

    public static <T> BasicInjectionTarget<T> createDefault(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        return new BasicInjectionTarget<T>(type, bean, beanManager, null);
    }

    public static <T> BasicInjectionTarget<T> createDefault(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager, Instantiator<T> instantiator) {
        return new BasicInjectionTarget<T>(type, bean, beanManager, instantiator);
    }

    public static <T> BasicInjectionTarget<T> createNonCdiInterceptor(EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        return new BasicInjectionTarget<T>(type, null, beanManager, DefaultInjector.of(type, null, beanManager), NoopLifecycleCallbackInvoker.getInstance());
    }

    protected BasicInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager, Injector<T> injector, LifecycleCallbackInvoker<T> invoker) {
        this(type, bean, beanManager, injector, invoker, null);
    }

    protected BasicInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager, Injector<T> injector, LifecycleCallbackInvoker<T> invoker, Instantiator<T> instantiator) {
        this.beanManager = beanManager;
        this.type = type.slim();
        this.injector = injector;
        this.invoker = invoker;
        HashSet<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();
        this.checkType(type);
        this.injector.registerInjectionPoints(injectionPoints);
        this.instantiator = instantiator != null ? instantiator : this.initInstantiator(type, bean, beanManager, injectionPoints);
        this.injectionPoints = ImmutableSet.copyOf(injectionPoints);
        this.checkDelegateInjectionPoints();
    }

    protected BasicInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager, Instantiator<T> instantiator) {
        this(type, bean, beanManager, DefaultInjector.of(type, bean, beanManager), DefaultLifecycleCallbackInvoker.of(type), instantiator);
    }

    protected void checkType(EnhancedAnnotatedType<T> type) {
        if (Reflections.isNonStaticInnerClass(type.getJavaClass())) {
            throw BeanLogger.LOG.simpleBeanAsNonStaticInnerClassNotAllowed(type);
        }
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        return this.instantiator.newInstance(ctx, this.beanManager);
    }

    @Override
    public void inject(T instance, CreationalContext<T> ctx) {
        this.injector.inject(instance, ctx, this.beanManager, this.type, this);
    }

    @Override
    public void postConstruct(T instance) {
        this.invoker.postConstruct(instance, this.instantiator);
    }

    @Override
    public void preDestroy(T instance) {
        this.invoker.preDestroy(instance, this.instantiator);
    }

    @Override
    public void dispose(T instance) {
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    protected SlimAnnotatedType<T> getType() {
        return this.type;
    }

    public BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public Instantiator<T> getInstantiator() {
        return this.instantiator;
    }

    public void setInstantiator(Instantiator<T> instantiator) {
        this.instantiator = instantiator;
    }

    public boolean hasInterceptors() {
        return this.instantiator.hasInterceptorSupport();
    }

    public boolean hasDecorators() {
        return this.instantiator.hasDecoratorSupport();
    }

    protected void initializeAfterBeanDiscovery(EnhancedAnnotatedType<T> annotatedType) {
    }

    protected Instantiator<T> initInstantiator(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager, Set<InjectionPoint> injectionPoints) {
        DefaultInstantiator<T> instantiator = new DefaultInstantiator<T>(type, bean, beanManager);
        injectionPoints.addAll(instantiator.getParameterInjectionPoints());
        return instantiator;
    }

    @Override
    public AnnotatedType<T> getAnnotated() {
        return this.type;
    }

    @Override
    public AnnotatedType<T> getAnnotatedType() {
        return this.getAnnotated();
    }

    public Injector<T> getInjector() {
        return this.injector;
    }

    public LifecycleCallbackInvoker<T> getLifecycleCallbackInvoker() {
        return this.invoker;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("InjectionTarget for ");
        if (this.getBean() == null) {
            result.append(this.getAnnotated());
        } else {
            result.append(this.getBean());
        }
        return result.toString();
    }

    @Override
    public Bean<T> getBean() {
        return null;
    }
}

