/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import javax.enterprise.context.spi.Context;
import javax.servlet.http.HttpServletRequest;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.weld.servlet.ServletContextService;

@MessageLogger(projectCode="WELD-")
public interface ServletLogger
extends WeldLogger {
    public static final ServletLogger LOG = Logger.getMessageLogger(ServletLogger.class, Category.SERVLET.getName());

    @Message(id=707, value="Non Http-Servlet lifecycle not defined")
    public IllegalStateException onlyHttpServletLifecycleDefined();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=708, value="Initializing request {0}", format=Message.Format.MESSAGE_FORMAT)
    public void requestInitialized(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=709, value="Destroying request {0}", format=Message.Format.MESSAGE_FORMAT)
    public void requestDestroyed(Object var1);

    @Message(id=710, value="Cannot inject {0} outside of a Servlet request", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException cannotInjectObjectOutsideOfServletRequest(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=711, value="Context activation pattern {0} ignored as it is overriden by the integrator.", format=Message.Format.MESSAGE_FORMAT)
    public void webXmlMappingPatternIgnored(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=712, value="Unable to dissociate context {0} when destroying request {1}", format=Message.Format.MESSAGE_FORMAT)
    public void unableToDissociateContext(Context var1, HttpServletRequest var2);

    @Message(id=713, value="Unable to inject ServletContext. None is associated with {0}, {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException cannotInjectServletContext(ClassLoader var1, ServletContextService var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=714, value="HttpContextLifecycle guard leak detected. The Servlet container is not fully compliant. The value was {0}", format=Message.Format.MESSAGE_FORMAT)
    public void guardLeak(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=715, value="HttpContextLifecycle guard not set. The Servlet container is not fully compliant.", format=Message.Format.MESSAGE_FORMAT)
    public void guardNotSet();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=716, value="Running in Servlet 2.x environment. Asynchronous request support is disabled.")
    public void servlet2Environment();
}

