/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.events.BeanAttributesBuilder;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.experimental.BeanBuilder;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.DeploymentStructures;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.bean.ForwardingBeanAttributes;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public final class BeanBuilderImpl<T>
extends BeanAttributesBuilder<T, BeanBuilder<T>>
implements BeanBuilder<T> {
    private static final String CALLBACK_PARAM = "callback";
    private final DeploymentFinder deploymentFinder;
    private BeanManagerImpl beanManager;
    private String id;
    private Class<?> beanClass;
    private Set<InjectionPoint> injectionPoints;
    private CreateCallback<T> createCallback;
    private DestroyCallback<T> destroyCallback;

    public BeanBuilderImpl(Class<? extends Extension> extensionClass, BeanDeploymentArchiveMapping bdaMapping, Deployment deployment, Collection<ContextHolder<? extends Context>> contexts, BeanManagerImpl deploymentManager) {
        Preconditions.checkArgumentNotNull(extensionClass, "extensionClass");
        Preconditions.checkArgumentNotNull(bdaMapping, "bdaMapping");
        Preconditions.checkArgumentNotNull(deployment, "deployment");
        Preconditions.checkArgumentNotNull(contexts, "contexts");
        Preconditions.checkArgumentNotNull(deploymentManager, "deploymentManager");
        this.deploymentFinder = new DeploymentFinder(bdaMapping, deployment, contexts, deploymentManager);
        this.beanClass(extensionClass);
        this.injectionPoints = new HashSet<InjectionPoint>();
    }

    @Override
    public Bean<T> build() {
        this.validate();
        return new ImmutableBean(this.beanManager, this.id, this.beanClass, super.build(), this.injectionPoints, this.createCallback, this.destroyCallback);
    }

    @Override
    public <U extends T> BeanBuilder<U> read(AnnotatedType<U> type) {
        Preconditions.checkArgumentNotNull(type, "type");
        this.beanClass(type.getJavaClass());
        InjectionTarget injectionTarget = (InjectionTarget)Reflections.cast(this.beanManager.getInjectionTargetFactory(type).createInjectionTarget((Bean)null));
        this.injectionPoints(injectionTarget.getInjectionPoints());
        this.createWith(c -> {
            Object instance = injectionTarget.produce(c);
            injectionTarget.inject(instance, c);
            injectionTarget.postConstruct(instance);
            return instance;
        });
        this.destroyWith((i, c) -> {
            injectionTarget.preDestroy(i);
            c.release();
        });
        return (BeanBuilder)Reflections.cast(this.read(this.beanManager.createBeanAttributes(type)));
    }

    @Override
    public BeanBuilder<T> read(BeanAttributes<?> beanAttributes) {
        Preconditions.checkArgumentNotNull(beanAttributes, "beanAttributes");
        this.scope(beanAttributes.getScope());
        this.name(beanAttributes.getName());
        this.alternative(beanAttributes.isAlternative());
        this.qualifiers(beanAttributes.getQualifiers());
        this.stereotypes(beanAttributes.getStereotypes());
        this.types(beanAttributes.getTypes());
        return this;
    }

    @Override
    public BeanBuilder<T> beanClass(Class<?> beanClass) {
        Preconditions.checkArgumentNotNull(beanClass, "beanClass");
        this.beanClass = beanClass;
        this.beanManager = this.deploymentFinder.getOrCreateBeanDeployment(beanClass).getBeanManager();
        return this;
    }

    @Override
    public BeanBuilder<T> addInjectionPoint(InjectionPoint injectionPoint) {
        this.injectionPoints.add(injectionPoint);
        return this;
    }

    @Override
    public BeanBuilder<T> injectionPoints(InjectionPoint ... injectionPoints) {
        this.injectionPoints = new HashSet<InjectionPoint>();
        Collections.addAll(this.injectionPoints, injectionPoints);
        return this;
    }

    @Override
    public BeanBuilder<T> injectionPoints(Set<InjectionPoint> injectionPoints) {
        Preconditions.checkArgumentNotNull(injectionPoints, "injectionPoints");
        this.injectionPoints = new HashSet<InjectionPoint>(injectionPoints);
        return null;
    }

    @Override
    public BeanBuilder<T> id(String id) {
        Preconditions.checkArgumentNotNull(id, "id");
        this.id = id;
        return this;
    }

    @Override
    public <U extends T> BeanBuilder<U> createWith(Function<CreationalContext<U>, U> callback) {
        Preconditions.checkArgumentNotNull(callback, CALLBACK_PARAM);
        this.createCallback = (CreateCallback)Reflections.cast(CreateCallback.fromCreateWith(callback));
        return (BeanBuilder)Reflections.cast(this);
    }

    @Override
    public <U extends T> BeanBuilder<U> produceWith(Function<Instance<Object>, U> callback) {
        Preconditions.checkArgumentNotNull(callback, CALLBACK_PARAM);
        this.createCallback = (CreateCallback)Reflections.cast(CreateCallback.fromProduceWith(callback));
        if (this.destroyCallback == null) {
            this.destroyCallback = new DestroyCallback<Object>(i -> {});
        }
        return (BeanBuilder)Reflections.cast(this);
    }

    @Override
    public <U extends T> BeanBuilder<U> produceWith(Supplier<U> callback) {
        Preconditions.checkArgumentNotNull(callback, CALLBACK_PARAM);
        this.createCallback = (CreateCallback)Reflections.cast(CreateCallback.fromProduceWith(callback));
        if (this.destroyCallback == null) {
            this.destroyCallback = new DestroyCallback<Object>(i -> {});
        }
        return (BeanBuilder)Reflections.cast(this);
    }

    @Override
    public BeanBuilder<T> destroyWith(BiConsumer<T, CreationalContext<T>> callback) {
        Preconditions.checkArgumentNotNull(callback, CALLBACK_PARAM);
        this.destroyCallback = new DestroyCallback<T>(callback);
        return this;
    }

    @Override
    public BeanBuilder<T> disposeWith(Consumer<T> callback) {
        Preconditions.checkArgumentNotNull(callback, CALLBACK_PARAM);
        this.destroyCallback = new DestroyCallback<T>(callback);
        return null;
    }

    @Override
    protected BeanBuilder<T> self() {
        return this;
    }

    BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    void validate() {
        if (this.createCallback == null) {
            throw BeanLogger.LOG.beanBuilderInvalidCreateCallback(this);
        }
        if (this.destroyCallback == null) {
            throw BeanLogger.LOG.beanBuilderInvalidDestroyCallback(this);
        }
    }

    public String toString() {
        return String.format("BeanBuilderImpl [id=%s, beanClass=%s, qualifiers=%s, types=%s]", this.id, this.beanClass, this.qualifiers, this.types);
    }

    static class DeploymentFinder {
        private final BeanDeploymentArchiveMapping bdaMapping;
        private final Deployment deployment;
        private final Collection<ContextHolder<? extends Context>> contexts;
        private final BeanManagerImpl deploymentManager;

        DeploymentFinder(BeanDeploymentArchiveMapping bdaMapping, Deployment deployment, Collection<ContextHolder<? extends Context>> contexts, BeanManagerImpl deploymentManager) {
            this.bdaMapping = bdaMapping;
            this.deployment = deployment;
            this.contexts = contexts;
            this.deploymentManager = deploymentManager;
        }

        BeanDeployment getOrCreateBeanDeployment(Class<?> clazz) {
            return DeploymentStructures.getOrCreateBeanDeployment(this.deployment, this.deploymentManager, this.bdaMapping, this.contexts, clazz);
        }
    }

    static class DestroyCallback<T> {
        private final BiConsumer<T, CreationalContext<T>> destroy;
        private final Consumer<T> simple;

        public DestroyCallback(Consumer<T> callback) {
            this.destroy = null;
            this.simple = callback;
        }

        public DestroyCallback(BiConsumer<T, CreationalContext<T>> callback) {
            this.destroy = callback;
            this.simple = null;
        }

        void destroy(T instance, CreationalContext<T> ctx) {
            if (this.simple != null) {
                this.simple.accept(instance);
            } else {
                this.destroy.accept(instance, ctx);
            }
        }
    }

    static class CreateCallback<T> {
        private final Supplier<T> simple;
        private final Function<CreationalContext<T>, T> create;
        private final Function<Instance<Object>, T> instance;

        static <T> CreateCallback<T> fromProduceWith(Function<Instance<Object>, T> callback) {
            return new CreateCallback<T>(null, null, callback);
        }

        static <T> CreateCallback<T> fromProduceWith(Supplier<T> callback) {
            return new CreateCallback<T>(callback, null, null);
        }

        static <T> CreateCallback<T> fromCreateWith(Function<CreationalContext<T>, T> callback) {
            return new CreateCallback<T>(null, callback, null);
        }

        public CreateCallback(Supplier<T> simple, Function<CreationalContext<T>, T> create, Function<Instance<Object>, T> instance) {
            this.simple = simple;
            this.create = create;
            this.instance = instance;
        }

        T create(CreationalContext<T> ctx, BeanManagerImpl beanManager) {
            if (this.simple != null) {
                return this.simple.get();
            }
            if (this.instance != null) {
                return this.instance.apply(beanManager.getInstance(ctx));
            }
            return this.create.apply(ctx);
        }
    }

    static class ImmutableBean<T>
    extends ForwardingBeanAttributes<T>
    implements Bean<T>,
    PassivationCapable {
        private final String id;
        private final BeanManagerImpl beanManager;
        private final Class<?> beanClass;
        private final BeanAttributes<T> attributes;
        private final Set<InjectionPoint> injectionPoints;
        private final CreateCallback<T> createCallback;
        private final DestroyCallback<T> destroyCallback;

        ImmutableBean(BeanManagerImpl beanManager, String id, Class<?> beanClass, BeanAttributes<T> attributes, Set<InjectionPoint> injectionPoints, CreateCallback<T> createCallback, DestroyCallback<T> destroyCallback) {
            this.beanManager = beanManager;
            this.beanClass = beanClass;
            this.attributes = attributes;
            this.injectionPoints = ImmutableSet.copyOf(injectionPoints);
            this.createCallback = createCallback;
            this.destroyCallback = destroyCallback;
            this.id = id != null ? id : BeanIdentifiers.forBuilderBean(attributes, beanClass);
        }

        @Override
        public T create(CreationalContext<T> creationalContext) {
            return this.createCallback.create(creationalContext, this.beanManager);
        }

        @Override
        public void destroy(T instance, CreationalContext<T> creationalContext) {
            this.destroyCallback.destroy(instance, creationalContext);
        }

        @Override
        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        protected BeanAttributes<T> attributes() {
            return this.attributes;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String toString() {
            return "Immutable Builder Bean [" + this.getBeanClass().toString() + "] with types [" + Formats.formatTypes(this.getTypes()) + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "]";
        }
    }
}

