/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Invocation;
import org.jboss.weld.probe.Monitored;
import org.jboss.weld.probe.Probe;

@Priority(value=1000)
@Monitored
@Interceptor
@Dependent
public class InvocationMonitor
implements Serializable {
    private static final long serialVersionUID = -5245789370968148511L;
    private static final ThreadLocal<Invocation.Builder> invocations = new ThreadLocal();
    private static final AtomicInteger invocationIdGenerator = new AtomicInteger(0);
    @Intercepted
    @Inject
    private Bean<?> interceptedBean;
    @Inject
    private BeanManagerImpl beanManager;
    private volatile transient Probe probe = null;
    private volatile transient Boolean skipJavaBeanProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object monitor(InvocationContext ctx) throws Exception {
        if (this.probe == null) {
            this.initProbe();
        }
        if (this.skipJavaBeanProperties == null) {
            this.initSkipJavaBeanProperties();
        }
        if (this.skipJavaBeanProperties.booleanValue() && this.isJavaBeanPropertyAccessor(ctx.getMethod())) {
            return ctx.proceed();
        }
        Invocation.Builder builder = invocations.get();
        boolean entryPoint = false;
        try {
            if (builder == null) {
                entryPoint = true;
                builder = Invocation.Builder.newBuilder(invocationIdGenerator.incrementAndGet());
                invocations.set(builder);
            } else {
                builder = builder.newChild();
                invocations.set(builder);
            }
            if (this.interceptedBean != null) {
                builder.setInterceptedBean(this.interceptedBean);
            } else {
                builder.setDeclaringClassName(ctx.getMethod().getDeclaringClass().getName());
            }
            builder.guessType(ctx);
            builder.setStart(System.currentTimeMillis());
            builder.setMethodName(ctx.getMethod().getName());
            long start = System.nanoTime();
            Object result = ctx.proceed();
            builder.setDuration(System.nanoTime() - start);
            if (entryPoint) {
                this.probe.addInvocation(builder.build());
            } else {
                invocations.set(builder.getParent());
            }
            Object object = result;
            return object;
        }
        finally {
            if (entryPoint) {
                invocations.remove();
            }
        }
    }

    private synchronized void initProbe() {
        if (this.probe == null) {
            this.probe = this.beanManager.getServices().get(Probe.class);
        }
    }

    private synchronized void initSkipJavaBeanProperties() {
        if (this.skipJavaBeanProperties == null) {
            this.skipJavaBeanProperties = this.beanManager.getServices().get(WeldConfiguration.class).getBooleanProperty(ConfigurationKey.PROBE_INVOCATION_MONITOR_SKIP_JAVABEAN_PROPERTIES);
        }
    }

    private boolean isJavaBeanPropertyAccessor(Method method) {
        if (method.getParameterCount() == 0) {
            return method.getName().startsWith("get") || method.getName().startsWith("is");
        }
        if (method.getParameterCount() == 1) {
            return method.getName().startsWith("set");
        }
        return false;
    }
}

