/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.probe.Resource;

public class ProbeServlet
extends HttpServlet {
    public static final String DEFAULT_URL_PATTERN = "/weld-probe/*";
    private static final long serialVersionUID = -881168492978480911L;
    @Inject
    private BeanManagerImpl beanManager;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp, Resource.HttpMethod.GET);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp, Resource.HttpMethod.DELETE);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Resource.Handler.setCorsHeaders(resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp, Resource.HttpMethod httpMethod) throws IOException {
        Resource resource;
        Probe probe = this.getProbe();
        String[] pathInfoParts = this.getPathInfoParts(req);
        if (pathInfoParts == null) {
            resource = Resource.CLIENT_RESOURCE;
        } else {
            resource = this.matchResource(pathInfoParts);
            if (resource == null) {
                resp.sendError(404);
                return;
            }
        }
        ProbeLogger.LOG.resourceMatched((Object)resource, req.getPathInfo());
        resource.handle(this.beanManager, probe, httpMethod, pathInfoParts, req, resp);
    }

    private Resource matchResource(String[] pathInfoParts) {
        for (Resource resource : Resource.values()) {
            if (!resource.matches(pathInfoParts)) continue;
            return resource;
        }
        return null;
    }

    private String[] getPathInfoParts(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        return pathInfo != null ? Resource.splitPath(pathInfo) : null;
    }

    private Probe getProbe() {
        if (this.beanManager == null) {
            throw ProbeLogger.LOG.probeServletUnableToOperate(BeanManagerImpl.class);
        }
        Probe probe = this.beanManager.getServices().get(Probe.class);
        if (probe == null) {
            throw ProbeLogger.LOG.probeServletUnableToOperate(Probe.class);
        }
        return probe;
    }
}

