/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Components;
import org.jboss.weld.probe.Invocation;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.probe.ProbeObserver;

final class Queries {
    static final int DEFAULT_PAGE_SIZE = 50;

    private Queries() {
    }

    static <T, F extends Filters<T>> Page<T> find(List<T> data, int page, int pageSize, F filters) {
        if (filters != null) {
            ProbeLogger.LOG.filtersApplied(filters);
            Iterator<T> iterator = data.iterator();
            while (iterator.hasNext()) {
                T element = iterator.next();
                if (filters.test(element)) continue;
                iterator.remove();
            }
        }
        if (pageSize == 0) {
            return new Page<T>(page, 1, data.size(), data);
        }
        if (data.isEmpty()) {
            return new Page(0, 0, 0, Collections.emptyList());
        }
        if (page <= 0 || page > 1 && (page - 1) * pageSize >= data.size()) {
            page = 1;
        }
        int lastIdx = data.size() / pageSize;
        if (data.size() % pageSize > 0) {
            ++lastIdx;
        }
        if (lastIdx == 1) {
            return new Page<T>(1, lastIdx, data.size(), data);
        }
        int start = (page - 1) * pageSize;
        int end = start + pageSize;
        if (end > data.size()) {
            end = data.size();
        }
        return new Page<T>(page, lastIdx, data.size(), data.subList(start, end));
    }

    static class EventsFilters
    extends Filters<ProbeObserver.EventInfo> {
        private Boolean container;
        private String eventInfo;
        private String type;
        private String qualifiers;

        EventsFilters(Probe probe) {
            super(probe);
        }

        @Override
        boolean test(ProbeObserver.EventInfo event) {
            return this.testContainsIgnoreCase(this.eventInfo, event.eventString) && this.testContainsIgnoreCase(this.type, event.type) && this.testContainsIgnoreCase(this.qualifiers, event.qualifiers) && (this.container == null || this.container == event.containerEvent);
        }

        @Override
        void processFilter(String name, String value) {
            if ("eventInfo".equals(name)) {
                this.eventInfo = value;
            } else if ("type".equals(name)) {
                this.type = value;
            } else if ("qualifiers".equals(name)) {
                this.qualifiers = value;
            } else if ("kind".equals(name)) {
                if ("container".equalsIgnoreCase(value)) {
                    this.container = true;
                } else if ("application".equalsIgnoreCase(value)) {
                    this.container = false;
                }
            }
        }

        public String toString() {
            return String.format("EventsFilters [container=%s, eventInfo=%s, type=%s, qualifiers=%s]", this.container, this.eventInfo, this.type, this.qualifiers);
        }
    }

    static class InvocationsFilters
    extends Filters<Invocation> {
        private String beanClass;
        private String methodName;
        private String search;

        InvocationsFilters(Probe probe) {
            super(probe);
        }

        @Override
        boolean test(Invocation invocation) {
            return this.testSearch(this.search, invocation) && this.testContainsIgnoreCase(this.beanClass, invocation.getBeanClass()) && this.testContainsIgnoreCase(this.methodName, invocation.getMethodName());
        }

        @Override
        void processFilter(String name, String value) {
            if ("beanClass".equals(name)) {
                this.beanClass = value;
            } else if ("methodName".equals(name)) {
                this.methodName = value;
            } else if ("search".equals(name)) {
                this.search = value;
            }
        }

        boolean testSearch(String search, Invocation invocation) {
            if (search == null) {
                return true;
            }
            if (this.containsIgnoreCase(search, invocation.getBeanClass()) || this.containsIgnoreCase(search, invocation.getMethodName())) {
                return true;
            }
            if (invocation.hasChildren()) {
                for (Invocation child : invocation.getChildren()) {
                    if (!this.testSearch(search, child)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return String.format("InvocationsFilters [beanClass=%s, methodName=%s, search=%s]", this.beanClass, this.methodName, this.search);
        }
    }

    static class ObserverFilters
    extends Filters<ObserverMethod<?>> {
        private String beanClass;
        private String observedType;
        private String qualifier;
        private Reception reception;
        private TransactionPhase txPhase;
        private Components.BeanKind declaringBeanKind;
        private String bda;

        ObserverFilters(Probe probe) {
            super(probe);
        }

        @Override
        boolean test(ObserverMethod<?> observer) {
            RIBean declaringBean = observer instanceof ObserverMethodImpl ? ((ObserverMethodImpl)observer).getDeclaringBean() : null;
            return this.testBda(this.bda, declaringBean) && this.testEquals((Object)this.declaringBeanKind, (Object)Components.BeanKind.from(declaringBean)) && this.testEquals((Object)this.reception, (Object)observer.getReception()) && this.testEquals((Object)this.txPhase, (Object)observer.getTransactionPhase()) && this.testContainsIgnoreCase(this.beanClass, observer.getBeanClass()) && this.testContainsIgnoreCase(this.observedType, observer.getObservedType()) && this.testAnyContains(this.qualifier, observer.getObservedQualifiers());
        }

        @Override
        void processFilter(String name, String value) {
            if ("kind".equals(name)) {
                this.declaringBeanKind = Components.BeanKind.from(value);
            } else if ("beanClass".equals(name)) {
                this.beanClass = value;
            } else if ("observedType".equals(name)) {
                this.observedType = value;
            } else if ("qualifier".equals(name)) {
                this.qualifier = value;
            } else if ("reception".equals(name)) {
                for (Reception recept : Reception.values()) {
                    if (!recept.toString().equals(value)) continue;
                    this.reception = recept;
                }
            } else if ("txPhase".equals(name)) {
                for (TransactionPhase phase : TransactionPhase.values()) {
                    if (!phase.toString().equals(value)) continue;
                    this.txPhase = phase;
                }
            } else if ("bda".equals(name)) {
                this.bda = value;
            }
        }

        public String toString() {
            return String.format("ObserverFilters [beanClass=%s, observedType=%s, qualifier=%s, reception=%s, txPhase=%s, declaringBeanKind=%s, bda=%s]", new Object[]{this.beanClass, this.observedType, this.qualifier, this.reception, this.txPhase, this.declaringBeanKind, this.bda});
        }
    }

    static class BeanFilters
    extends Filters<Bean<?>> {
        private Components.BeanKind kind;
        private String beanClass;
        private String beanType;
        private String qualifier;
        private String scope;
        private String bda;
        private Boolean isAlternative;
        private String stereotypes;

        BeanFilters(Probe probe) {
            super(probe);
        }

        @Override
        public boolean test(Bean<?> bean) {
            return this.testBda(this.bda, bean) && this.testEquals((Object)this.kind, (Object)Components.BeanKind.from(bean)) && this.testContainsIgnoreCase(this.beanClass, bean.getBeanClass()) && this.testContainsIgnoreCase(this.scope, bean.getScope()) && this.testAnyContains(this.beanType, bean.getTypes()) && this.testAnyContains(this.qualifier, bean.getQualifiers()) && this.testEquals(this.isAlternative, bean.isAlternative()) && this.testAnyContains(this.stereotypes, bean.getStereotypes());
        }

        @Override
        void processFilter(String name, String value) {
            if ("kind".equals(name)) {
                this.kind = Components.BeanKind.from(value);
            } else if ("beanClass".equals(name)) {
                this.beanClass = value;
            } else if ("beanType".equals(name)) {
                this.beanType = value;
            } else if ("qualifier".equals(name)) {
                this.qualifier = value;
            } else if ("scope".equals(name)) {
                this.scope = value;
            } else if ("bda".equals(name)) {
                this.bda = value;
            } else if ("isAlternative".equals(name)) {
                this.isAlternative = Boolean.valueOf(value);
            } else if ("stereotypes".equals(name)) {
                this.stereotypes = value;
            }
        }

        public String toString() {
            return String.format("BeanFilters [kind=%s, beanClass=%s, beanType=%s, qualifier=%s, scope=%s, bda=%s, isAlternative=%s, stereotypes=%s]", new Object[]{this.kind, this.beanClass, this.beanType, this.qualifier, this.scope, this.bda, this.isAlternative, this.stereotypes});
        }
    }

    static abstract class Filters<T> {
        private static final String SEPARATOR = ":";
        protected static final String FILTER_ADDITIONAL_BDAS_MARKER = "probe-filterAdditionalBdas";
        protected final Probe probe;

        public Filters(Probe probe) {
            this.probe = probe;
        }

        void processFilters(String filters) {
            String[] tokens;
            for (String token : tokens = filters.trim().split(" ")) {
                String[] parts;
                if (token.length() == 0 || (parts = token.split(SEPARATOR)).length != 2) continue;
                this.processFilter(parts[0], parts[1]);
            }
        }

        abstract boolean test(T var1);

        abstract void processFilter(String var1, String var2);

        boolean testEquals(Object filter, Object value) {
            return filter == null || filter.equals(value);
        }

        boolean testContainsIgnoreCase(String filter, Object value) {
            return filter == null || this.containsIgnoreCase(filter, value);
        }

        boolean testAnyContains(String filter, Collection<?> values) {
            if (filter == null) {
                return true;
            }
            for (Object value : values) {
                if (!this.testContainsIgnoreCase(filter, value)) continue;
                return true;
            }
            return false;
        }

        boolean testBda(String bda, Bean<?> bean) {
            if (bda == null) {
                return true;
            }
            if (bean == null) {
                return false;
            }
            BeanManagerImpl beanManagerImpl = this.probe.getBeanManager(bean);
            if (beanManagerImpl == null) {
                return false;
            }
            return !(FILTER_ADDITIONAL_BDAS_MARKER.equals(bda) ? beanManagerImpl.getId().endsWith(".additionalClasses") : !Components.getId(beanManagerImpl.getId()).equals(bda));
        }

        boolean containsIgnoreCase(String filter, Object value) {
            return value.toString().toLowerCase().contains(filter.toLowerCase());
        }
    }

    static class Page<T> {
        private final int idx;
        private final int lastIdx;
        private final int total;
        private final List<T> data;

        Page(int idx, int lastIdx, int total, List<T> data) {
            this.idx = idx;
            this.lastIdx = lastIdx;
            this.total = total;
            this.data = data;
        }

        int getIdx() {
            return this.idx;
        }

        int getLastIdx() {
            return this.lastIdx;
        }

        int getTotal() {
            return this.total;
        }

        List<T> getData() {
            return this.data;
        }
    }
}

