/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.web;

import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpLiteral;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpRequestContextImpl;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.context.http.HttpSessionContextImpl;
import org.jboss.weld.context.http.HttpSessionDestructionContext;
import org.jboss.weld.context.http.LazyHttpConversationContextImpl;
import org.jboss.weld.el.WeldELResolver;
import org.jboss.weld.el.WeldExpressionFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.ExpressionLanguageService;
import org.jboss.weld.module.WeldModule;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.serialization.BeanIdentifierIndex;
import org.jboss.weld.servlet.ServletApiAbstraction;
import org.jboss.weld.servlet.ServletContextService;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.web.HttpServletRequestBean;
import org.jboss.weld.web.HttpSessionBean;
import org.jboss.weld.web.ServletContextBean;

public class WeldWebModule
implements WeldModule {
    public static final ExpressionLanguageService EL_SERVICE = new ExpressionLanguageService(){

        @Override
        public void cleanup() {
        }

        @Override
        public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
            return new WeldExpressionFactory(expressionFactory);
        }

        @Override
        public ELResolver createElResolver(BeanManagerImpl manager) {
            return new WeldELResolver(manager);
        }
    };

    @Override
    public String getName() {
        return "weld-web";
    }

    @Override
    public void postServiceRegistration(WeldModule.PostServiceRegistrationContext ctx) {
        ctx.getServices().add(ExpressionLanguageService.class, EL_SERVICE);
        ctx.getServices().add(ServletContextService.class, new ServletContextService());
        ctx.getServices().add(ServletApiAbstraction.class, new ServletApiAbstraction(WeldClassLoaderResourceLoader.INSTANCE));
    }

    @Override
    public void postContextRegistration(WeldModule.PostContextRegistrationContext ctx) {
        BeanIdentifierIndex index = ctx.getServices().get(BeanIdentifierIndex.class);
        String contextId = ctx.getContextId();
        if (Reflections.isClassLoadable("javax.servlet.ServletContext", WeldClassLoaderResourceLoader.INSTANCE)) {
            ctx.addContext(new ContextHolder<HttpSessionContext>(new HttpSessionContextImpl(contextId, index), HttpSessionContext.class, HttpLiteral.INSTANCE));
            ctx.addContext(new ContextHolder<HttpSessionDestructionContext>(new HttpSessionDestructionContext(contextId, index), HttpSessionDestructionContext.class, HttpLiteral.INSTANCE));
            ctx.addContext(new ContextHolder<HttpConversationContext>(new LazyHttpConversationContextImpl(contextId, index), HttpConversationContext.class, HttpLiteral.INSTANCE));
            ctx.addContext(new ContextHolder<HttpRequestContext>(new HttpRequestContextImpl(contextId), HttpRequestContext.class, HttpLiteral.INSTANCE));
        }
    }

    @Override
    public void preBeanRegistration(WeldModule.PreBeanRegistrationContext ctx) {
        if (Reflections.isClassLoadable("javax.servlet.ServletContext", WeldClassLoaderResourceLoader.INSTANCE)) {
            ctx.registerBean(new HttpServletRequestBean(ctx.getBeanManager()));
            ctx.registerBean(new HttpSessionBean(ctx.getBeanManager()));
            ctx.registerBean(new ServletContextBean(ctx.getBeanManager()));
        }
    }
}

