/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Invocation;
import org.jboss.weld.probe.InvocationMonitor;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.util.reflection.Formats;

public class ProbeFilter
implements Filter {
    static final String WELD_SERVLET_BEAN_MANAGER_KEY = "org.jboss.weld.environment.servlet.javax.enterprise.inject.spi.BeanManager";
    @Inject
    private BeanManagerImpl beanManager;
    private String snippetBase;
    private Probe probe;

    public void init(FilterConfig filterConfig) throws ServletException {
        String exclude;
        Probe probe;
        if (this.beanManager == null) {
            this.beanManager = BeanManagerProxy.tryUnwrap(filterConfig.getServletContext().getAttribute(WELD_SERVLET_BEAN_MANAGER_KEY));
            if (this.beanManager == null) {
                throw ProbeLogger.LOG.probeFilterUnableToOperate(BeanManagerImpl.class);
            }
        }
        if ((probe = this.beanManager.getServices().get(Probe.class)) == null) {
            throw ProbeLogger.LOG.probeFilterUnableToOperate(Probe.class);
        }
        WeldConfiguration configuration = this.beanManager.getServices().get(WeldConfiguration.class);
        if (configuration.getBooleanProperty(ConfigurationKey.PROBE_EMBED_INFO_SNIPPET).booleanValue()) {
            StringBuilder builder = new StringBuilder();
            builder.append("<!-- The following snippet was automatically added by Weld, see the documentation to disable this functionality -->");
            builder.append("<div id=\"weld-dev-mode-info\" style=\"position: fixed !important;bottom:0;left:0;width:100%;background-color:#f8f8f8;border:2px solid silver;padding:10px;border-radius:2px;margin:0px;font-size:14px;font-family:sans-serif;color:black;\">");
            builder.append("<img alt=\"Weld logo\" style=\"vertical-align: middle;border-width:0px;\" src=\"");
            builder.append(filterConfig.getServletContext().getContextPath());
            builder.append("/weld-probe/client/weld_icon_32x.png\">");
            builder.append("&nbsp; Running on Weld <span style=\"color:gray\">");
            builder.append(Formats.version(WeldBootstrap.class.getPackage().getSpecificationVersion(), null));
            builder.append("</span>. The development mode is <span style=\"color:white;background-color:#d62728;padding:6px;border-radius:4px;font-size:12px;\">ENABLED</span>. Inspect your application with <a style=\"color:#337ab7;text-decoration:underline;\" href=\"");
            builder.append(filterConfig.getServletContext().getContextPath());
            builder.append("/weld-probe");
            builder.append("\" target=\"_blank\">Probe Development Tool</a>.");
            builder.append(" <button style=\"float:right;background-color:#f8f8f8;border:1px solid silver; color:gray;border-radius:4px;padding:4px 10px 4px 10px;margin-left:2em;font-weight: bold;\" onclick=\"document.getElementById('weld-dev-mode-info').style.display='none';\">x</button>");
            this.snippetBase = builder.toString();
        }
        if ((exclude = configuration.getStringProperty(ConfigurationKey.PROBE_INVOCATION_MONITOR_EXCLUDE_TYPE)).isEmpty() || !Pattern.compile(exclude).matcher(ProbeFilter.class.getName()).matches()) {
            this.probe = probe;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Invocation.Builder builder;
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (httpServletRequest.getServletPath().startsWith("/weld-probe")) {
            chain.doFilter(request, response);
            return;
        }
        if (this.probe != null) {
            builder = InvocationMonitor.initBuilder(false);
            if (builder != null) {
                builder.setDeclaringClassName(ProbeFilter.class.getName());
                builder.setStart(System.currentTimeMillis());
                builder.setMethodName("doFilter");
                builder.setType(Invocation.Type.BUSINESS);
                builder.setDescription(this.getDescription(httpServletRequest));
                builder.ignoreIfNoChildren();
            }
        } else {
            builder = null;
        }
        if (this.snippetBase == null) {
            FilterAction.of(request, response).doFilter(builder, this.probe, chain);
        } else {
            ResponseWrapper responseWrapper = new ResponseWrapper((HttpServletResponse)response);
            FilterAction.of(request, (ServletResponse)responseWrapper).doFilter(builder, this.probe, chain);
            String captured = responseWrapper.getOutput();
            if (captured != null && !captured.isEmpty()) {
                PrintWriter out = response.getWriter();
                if (response.getContentType() != null && response.getContentType().startsWith("text/html")) {
                    int idx = captured.indexOf("</body>");
                    if (idx == -1) {
                        out.write(captured);
                    } else {
                        CharArrayWriter writer = new CharArrayWriter();
                        writer.write(captured.substring(0, idx));
                        writer.write(this.snippetBase);
                        if (builder != null && !builder.isIgnored()) {
                            writer.write("See <a style=\"color:#337ab7;text-decoration:underline;\" href=\"");
                            writer.write(request.getServletContext().getContextPath());
                            writer.write("/weld-probe/#/invocation/");
                            writer.write("" + builder.getEntryPointIdx());
                            writer.write("\" target=\"_blank\">all bean invocations</a> within the HTTP request which rendered this page.");
                        }
                        writer.write("</div>");
                        writer.write(captured.substring(idx, captured.length()));
                        out.write(writer.toString());
                    }
                } else {
                    out.write(captured);
                }
            }
        }
    }

    public void destroy() {
    }

    private String getDescription(HttpServletRequest req) {
        StringBuilder builder = new StringBuilder();
        builder.append(req.getMethod());
        builder.append(' ');
        builder.append(req.getRequestURI());
        String queryString = req.getQueryString();
        if (queryString != null) {
            builder.append('?');
            builder.append(queryString);
        }
        return builder.toString();
    }

    private static class FilterAction
    extends InvocationMonitor.Action<FilterChain> {
        private final ServletRequest request;
        private final ServletResponse response;

        private static FilterAction of(ServletRequest request, ServletResponse response) {
            return new FilterAction(request, response);
        }

        private FilterAction(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        @Override
        protected Object proceed(FilterChain chain) throws Exception {
            chain.doFilter(this.request, this.response);
            return null;
        }

        void doFilter(Invocation.Builder builder, Probe probe, FilterChain chain) throws ServletException, IOException {
            if (builder == null) {
                chain.doFilter(this.request, this.response);
            } else {
                try {
                    this.perform(builder, probe, chain);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
    }

    private static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private final CharArrayWriter output = new CharArrayWriter();
        private final PrintWriter writer = new PrintWriter(this.output);

        ResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public PrintWriter getWriter() {
            return this.writer;
        }

        String getOutput() {
            return this.output.toString();
        }
    }
}

