/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.jetty;

import javax.servlet.ServletContext;
import org.jboss.weld.environment.jetty.JettyWeldInjector;
import org.jboss.weld.environment.servlet.logging.JettyLogger;

public class WeldDecorator {
    private JettyWeldInjector injector;

    protected WeldDecorator(ServletContext servletContext) {
        this.injector = (JettyWeldInjector)servletContext.getAttribute("org.jboss.weld.environment.jetty.JettyWeldInjector");
        if (this.injector == null) {
            throw JettyLogger.LOG.noSuchJettyInjectorFound();
        }
    }

    public static void process(ServletContext context) {
        String attribute = (String)context.getAttribute("org.eclipse.jetty.webapp.DecoratingListener");
        if (attribute == null) {
            throw new IllegalStateException("No Jetty Decorating Listener integration detected");
        }
        context.setAttribute(attribute, (Object)new WeldDecorator(context));
        JettyLogger.LOG.jettyDecorationIsSupported();
    }

    public <T> T decorate(T o) {
        this.injector.inject(o);
        return o;
    }

    public void destroy(Object o) {
        this.injector.destroy(o);
    }
}

