/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.environment.ContainerInstance;
import org.jboss.weld.environment.ContainerInstanceFactory;
import org.jboss.weld.environment.servlet.EnhancedListener;
import org.jboss.weld.environment.servlet.WeldServletLifecycle;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;
import org.jboss.weld.util.Preconditions;

public class Listener
extends ForwardingServletListener {
    public static final String CONTAINER_ATTRIBUTE_NAME = WeldServletLifecycle.class.getPackage().getName() + ".container";
    static final String LISTENER_USED_ATTRIBUTE_NAME = EnhancedListener.class.getPackage().getName() + ".listenerUsed";
    private volatile WeldServletLifecycle lifecycle;
    private final List<Consumer<ServletContext>> initActions;

    public static Listener using(BeanManager manager) {
        return new Listener(Collections.singletonList(Listener.initAction(WeldServletLifecycle.BEAN_MANAGER_ATTRIBUTE_NAME, manager)));
    }

    public static Listener using(ContainerInstance container) {
        return new Listener(Collections.singletonList(Listener.initAction(CONTAINER_ATTRIBUTE_NAME, container)));
    }

    public static Listener using(ContainerInstanceFactory container) {
        return new Listener(Collections.singletonList(Listener.initAction(CONTAINER_ATTRIBUTE_NAME, container)));
    }

    private static Consumer<ServletContext> initAction(String key, Object value) {
        Preconditions.checkNotNull(value);
        return context -> context.setAttribute(key, value);
    }

    public Listener() {
        this.initActions = Collections.emptyList();
    }

    private Listener(List<Consumer<ServletContext>> initActions) {
        this.initActions = initActions;
    }

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        this.lifecycle = (WeldServletLifecycle)context.getAttribute(WeldServletLifecycle.INSTANCE_ATTRIBUTE_NAME);
        context.setAttribute(LISTENER_USED_ATTRIBUTE_NAME, (Object)Boolean.TRUE);
        if (Boolean.TRUE.equals(context.getAttribute(EnhancedListener.ENHANCED_LISTENER_USED_ATTRIBUTE_NAME))) {
            WeldServletLogger.LOG.enhancedListenerUsedForNotifications();
            return;
        }
        WeldServletLogger.LOG.initializeWeldUsingServletContextListener();
        for (Consumer<ServletContext> initAction : this.initActions) {
            initAction.accept(context);
        }
        this.lifecycle = new WeldServletLifecycle();
        this.lifecycle.initialize(context);
        super.contextInitialized(sce);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if (this.lifecycle == null) {
            if (!Boolean.TRUE.equals(sce.getServletContext().getAttribute(EnhancedListener.ENHANCED_LISTENER_USED_ATTRIBUTE_NAME))) {
                WeldServletLogger.LOG.noServletLifecycleToDestroy();
            }
            return;
        }
        super.contextDestroyed(sce);
        this.lifecycle.destroy(sce.getServletContext());
    }

    @Override
    public void requestDestroyed(ServletRequestEvent sre) {
        if (this.lifecycle != null) {
            super.requestDestroyed(sre);
        }
    }

    @Override
    public void requestInitialized(ServletRequestEvent sre) {
        if (this.lifecycle != null) {
            super.requestInitialized(sre);
        }
    }

    @Override
    public void sessionCreated(HttpSessionEvent se) {
        if (this.lifecycle != null) {
            super.sessionCreated(se);
        }
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent se) {
        if (this.lifecycle != null) {
            super.sessionDestroyed(se);
        }
    }

    @Override
    protected ServletListener delegate() {
        return this.lifecycle.getWeldListener();
    }
}

