/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.weld.serialization.spi.ProxyServices;

public class ClassFileUtils {
    private static Method defineClass1;
    private static Method defineClass2;
    private static AtomicBoolean classLoaderMethodsMadeAccessible;

    private ClassFileUtils() {
    }

    public static void makeClassLoaderMethodsAccessible() {
        if (classLoaderMethodsMadeAccessible.compareAndSet(false, true)) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Class<?> cl = Class.forName("java.lang.ClassLoader");
                        String name = "defineClass";
                        defineClass1 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                        defineClass2 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                        defineClass1.setAccessible(true);
                        defineClass2.setAccessible(true);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new RuntimeException("cannot initialize ClassPool", pae.getException());
            }
        }
    }

    public static Class<?> toClass(ClassFile ct, ClassLoader loader, ProtectionDomain domain) {
        try {
            Object[] args;
            Method method;
            byte[] b = ct.toBytecode();
            if (domain == null) {
                method = defineClass1;
                args = new Object[]{ct.getName(), b, 0, b.length};
            } else {
                method = defineClass2;
                args = new Object[]{ct.getName(), b, 0, b.length, domain};
            }
            return ClassFileUtils.toClass2(method, loader, args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> toClass(ClassFile ct, Class<?> originalClass, ProxyServices proxyServices, ProtectionDomain domain) {
        try {
            byte[] bytecode = ct.toBytecode();
            Class<?> result = domain == null ? proxyServices.defineClass(originalClass, ct.getName(), bytecode, 0, bytecode.length) : proxyServices.defineClass(originalClass, ct.getName(), bytecode, 0, bytecode.length, domain);
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized Class<?> toClass2(Method method, ClassLoader loader, Object[] args) throws Exception {
        Class clazz = (Class)Class.class.cast(method.invoke((Object)loader, args));
        return clazz;
    }

    static {
        classLoaderMethodsMadeAccessible = new AtomicBoolean(false);
    }
}

