package org.jboss.weld.environment.servlet.logging;

import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-02-15T14:53:00+0100")
public class JettyLogger_$logger extends DelegatingBasicLogger implements JettyLogger, WeldEnvironmentLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JettyLogger_$logger.class.getName();
    public JettyLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void jettyDetectedListenersInjectionIsSupported() {
        super.log.logf(FQCN, INFO, null, jettyDetectedListenersInjectionIsSupported$str());
    }
    protected String jettyDetectedListenersInjectionIsSupported$str() {
        return "WELD-ENV-001200: Jetty 7.2+ detected, CDI injection will be available in Servlets and Filters. Injection into Listeners should work on Jetty 9.1.1 and newer.";
    }
    @Override
    public final void jettyDetectedListenersInjectionIsNotSupported() {
        super.log.logf(FQCN, INFO, null, jettyDetectedListenersInjectionIsNotSupported$str());
    }
    protected String jettyDetectedListenersInjectionIsNotSupported$str() {
        return "WELD-ENV-001201: Jetty 7.2+ detected, CDI injection will be available in Servlets and Filters. Injection into Listeners is not supported.";
    }
    @Override
    public final void unableToCreateJettyWeldInjector(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, unableToCreateJettyWeldInjector$str());
    }
    protected String unableToCreateJettyWeldInjector$str() {
        return "WELD-ENV-001202: Unable to create JettyWeldInjector. CDI injection will not be available in Servlets, Filters or Listeners.";
    }
    @Override
    public final void gwtHostedModeDetected() {
        super.log.logf(FQCN, INFO, null, gwtHostedModeDetected$str());
    }
    protected String gwtHostedModeDetected$str() {
        return "WELD-ENV-001203: GWTHostedMode detected, JSR-299 injection will be available in Servlets and Filters. Injection into Listeners is not supported.";
    }
    @Override
    public final void cantFindInjector(final Object param1) {
        super.log.logv(FQCN, WARN, null, cantFindInjector$str(), param1);
    }
    protected String cantFindInjector$str() {
        return "WELD-ENV-001204: Can't find Injector in the servlet context so injection is not available for {0}.";
    }
    @Override
    public final void missingJettyEnv() {
        super.log.logf(FQCN, WARN, null, missingJettyEnv$str());
    }
    protected String missingJettyEnv$str() {
        return "WELD-ENV-001205: Missing jetty-env.xml, no BeanManager present in JNDI.";
    }
    @Override
    public final void cantFindWebApplicationContext() {
        super.log.logf(FQCN, INFO, null, cantFindWebApplicationContext$str());
    }
    protected String cantFindWebApplicationContext$str() {
        return "WELD-ENV-001206: Cannot find matching WebApplicationContext, no default CDI support: use jetty-web.xml";
    }
    @Override
    public final void cantFindInjectior(final Object param1) {
        super.log.logv(FQCN, WARN, null, cantFindInjectior$str(), param1);
    }
    protected String cantFindInjectior$str() {
        return "WELD-ENV-001207: Can't find Injector in the servlet context so injection is not available for {0}.";
    }
    @Override
    public final void missingJettyEnvXml() {
        super.log.logf(FQCN, WARN, null, missingJettyEnvXml$str());
    }
    protected String missingJettyEnvXml$str() {
        return "WELD-ENV-001208: Missing jetty-env.xml, no BeanManager present in JNDI.";
    }
    @Override
    public final void cantFindMatchingWebApplicationContext() {
        super.log.logf(FQCN, INFO, null, cantFindMatchingWebApplicationContext$str());
    }
    protected String cantFindMatchingWebApplicationContext$str() {
        return "WELD-ENV-001209: Cannot find matching WebApplicationContext, no default CDI support: use jetty-web.xml";
    }
    protected String noSuchJettyInjectorFound$str() {
        return "WELD-ENV-001210: No such Jetty injector found in servlet context attributes.";
    }
    @Override
    public final IllegalStateException noSuchJettyInjectorFound() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noSuchJettyInjectorFound$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void jettyDecorationIsSupported() {
        super.log.logf(FQCN, WARN, null, jettyDecorationIsSupported$str());
    }
    protected String jettyDecorationIsSupported$str() {
        return "WELD-ENV-001211: Deprecated Jetty DecoratingListener support detected, CDI injection will be available in Listeners, Servlets and Filters.";
    }
    @Override
    public final void jettyCdiDecorationIsSupported() {
        super.log.logf(FQCN, INFO, null, jettyCdiDecorationIsSupported$str());
    }
    protected String jettyCdiDecorationIsSupported$str() {
        return "WELD-ENV-001212: Jetty CdiDecoratingListener support detected, CDI injection will be available in Listeners, Servlets and Filters.";
    }
    @Override
    public final void jettyCdiSpiIsSupported() {
        super.log.logf(FQCN, INFO, null, jettyCdiSpiIsSupported$str());
    }
    protected String jettyCdiSpiIsSupported$str() {
        return "WELD-ENV-001213: Jetty CDI SPI support detected, CDI injection will be available in Listeners, Servlets and Filters.";
    }
    protected String unknownIntegrationMode$str() {
        return "WELD-ENV-001214: Unknown Jetty integration mode: {0}";
    }
    @Override
    public final IllegalStateException unknownIntegrationMode(final String mode) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unknownIntegrationMode$str(), mode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    @Override
    public final void catchingDebug(final Throwable arg0) {
        super.log.logf(FQCN, DEBUG, arg0, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
    @Override
    public final void catchingTrace(final Throwable arg0) {
        super.log.logf(FQCN, TRACE, arg0, catchingTrace$str());
    }
    protected String catchingTrace$str() {
        return "Catching";
    }
}
