package org.jboss.weld.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.weld.exceptions.UnsatisfiedResolutionException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.weld.contexts.ContextNotActiveException;
import org.jboss.weld.exceptions.AmbiguousResolutionException;
import java.lang.Throwable;
import javax.naming.NamingException;
import java.lang.Object;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class BeanManagerLogger_$logger extends DelegatingBasicLogger implements BeanManagerLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = BeanManagerLogger_$logger.class.getName();
    public BeanManagerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String cannotLocateBeanManager$str() {
        return "WELD-001300: Unable to locate BeanManager";
    }
    @Override
    public final NamingException cannotLocateBeanManager() {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), cannotLocateBeanManager$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidQualifier$str() {
        return "WELD-001301: Annotation {0} is not a qualifier";
    }
    @Override
    public final IllegalArgumentException invalidQualifier(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidQualifier$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String duplicateQualifiers$str() {
        return "WELD-001302: Duplicate qualifiers:  {0}";
    }
    @Override
    public final IllegalArgumentException duplicateQualifiers(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(duplicateQualifiers$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String contextNotActive$str() {
        return "WELD-001303: No active contexts for scope type {0}";
    }
    @Override
    public final ContextNotActiveException contextNotActive(final Object param1) {
        final ContextNotActiveException result = new ContextNotActiveException(_formatMessage(contextNotActive$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateActiveContexts$str() {
        return "WELD-001304: More than one context active for scope type {0}";
    }
    @Override
    public final IllegalStateException duplicateActiveContexts(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(duplicateActiveContexts$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String specifiedTypeNotBeanType$str() {
        return "WELD-001305: The given type {0} is not a type of the bean {1}";
    }
    @Override
    public final IllegalArgumentException specifiedTypeNotBeanType(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(specifiedTypeNotBeanType$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unresolvableType$str() {
        return "WELD-001307: Unable to resolve any beans of type {0} with qualifiers {1}";
    }
    @Override
    public final UnsatisfiedResolutionException unresolvableType(final Object param1, final Object param2) {
        final UnsatisfiedResolutionException result = new UnsatisfiedResolutionException(_formatMessage(unresolvableType$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unresolvableElement$str() {
        return "WELD-001308: Unable to resolve any beans for {0}";
    }
    @Override
    public final UnsatisfiedResolutionException unresolvableElement(final Object param1) {
        final UnsatisfiedResolutionException result = new UnsatisfiedResolutionException(_formatMessage(unresolvableElement$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDecoratorTypes$str() {
        return "WELD-001310: No decorator types were specified in the set";
    }
    @Override
    public final IllegalArgumentException noDecoratorTypes() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noDecoratorTypes$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorBindingsEmpty$str() {
        return "WELD-001311: Interceptor bindings list cannot be empty";
    }
    @Override
    public final IllegalArgumentException interceptorBindingsEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), interceptorBindingsEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateInterceptorBinding$str() {
        return "WELD-001312: Duplicate interceptor binding type {0} found";
    }
    @Override
    public final IllegalArgumentException duplicateInterceptorBinding(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(duplicateInterceptorBinding$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorResolutionWithNonbindingType$str() {
        return "WELD-001313: Trying to resolve interceptors with non-binding type {0}";
    }
    @Override
    public final IllegalArgumentException interceptorResolutionWithNonbindingType(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(interceptorResolutionWithNonbindingType$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonNormalScope$str() {
        return "WELD-001314: {0} is expected to be a normal scope type";
    }
    @Override
    public final String nonNormalScope(final Object param1) {
        return _formatMessage(nonNormalScope$str(), param1);
    }
    protected String notInterceptorBindingType$str() {
        return "WELD-001316: {0} is not an interceptor binding type";
    }
    @Override
    public final IllegalArgumentException notInterceptorBindingType(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(notInterceptorBindingType$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notStereotype$str() {
        return "WELD-001317: {0} is not a stereotype";
    }
    @Override
    public final IllegalArgumentException notStereotype(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(notStereotype$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ambiguousBeansForDependency$str() {
        return "WELD-001318: Cannot resolve an ambiguous dependency between: {0}";
    }
    @Override
    public final AmbiguousResolutionException ambiguousBeansForDependency(final Object param1) {
        final AmbiguousResolutionException result = new AmbiguousResolutionException(_formatMessage(ambiguousBeansForDependency$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullBeanManagerId$str() {
        return "WELD-001319: Bean manager ID must not be null";
    }
    @Override
    public final IllegalArgumentException nullBeanManagerId() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullBeanManagerId$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noInstanceOfExtension$str() {
        return "WELD-001325: No instance of an extension {0} registered with the deployment";
    }
    @Override
    public final IllegalArgumentException noInstanceOfExtension(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(noInstanceOfExtension$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateBeanAttributesForIncorrectAnnotatedMember$str() {
        return "WELD-001326: Cannot create bean attributes - the argument must be either an AnnotatedField or AnnotatedMethod but {0} is not";
    }
    @Override
    public final IllegalArgumentException cannotCreateBeanAttributesForIncorrectAnnotatedMember(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(cannotCreateBeanAttributesForIncorrectAnnotatedMember$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ambiguousBeanManager$str() {
        return "WELD-001327: Unable to identify the correct BeanManager. The calling class {0} is placed in multiple bean archives";
    }
    @Override
    public final IllegalStateException ambiguousBeanManager(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(ambiguousBeanManager$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsatisfiedBeanManager$str() {
        return "WELD-001328: Unable to identify the correct BeanManager. The calling class {0} is not placed in bean archive";
    }
    @Override
    public final IllegalStateException unsatisfiedBeanManager(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unsatisfiedBeanManager$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToIdentifyBeanManager$str() {
        return "WELD-001329: Unable to identify the correct BeanManager";
    }
    @Override
    public final IllegalStateException unableToIdentifyBeanManager() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToIdentifyBeanManager$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanManagerNotAvailable$str() {
        return "WELD-001330: BeanManager is not available.";
    }
    @Override
    public final IllegalStateException beanManagerNotAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), beanManagerNotAvailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullDeclaringBean$str() {
        return "WELD-001331: Declaring bean cannot be null for the non-static member {0}";
    }
    @Override
    public final IllegalArgumentException nullDeclaringBean(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(nullDeclaringBean$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String methodNotAvailableDuringInitialization$str() {
        return "WELD-001332: BeanManager method {0} is not available during application initialization. Container state: {1}";
    }
    @Override
    public final IllegalStateException methodNotAvailableDuringInitialization(final Object param1, final Object state) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(methodNotAvailableDuringInitialization$str(), param1, state));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String methodNotAvailableAfterShutdown$str() {
        return "WELD-001333: BeanManager method {0} is not available after shutdown";
    }
    @Override
    public final IllegalStateException methodNotAvailableAfterShutdown(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(methodNotAvailableAfterShutdown$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionPointHasUnsatisfiedDependencies$str() {
        return "WELD-001334: Unsatisfied dependencies for type {1} with qualifiers {0} {2}";
    }
    @Override
    public final UnsatisfiedResolutionException injectionPointHasUnsatisfiedDependencies(final Object param1, final Object param2, final Object param3) {
        final UnsatisfiedResolutionException result = new UnsatisfiedResolutionException(_formatMessage(injectionPointHasUnsatisfiedDependencies$str(), param1, param2, param3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionPointHasAmbiguousDependencies$str() {
        return "WELD-001335: Ambiguous dependencies for type {1} with qualifiers {0}\n Possible dependencies: {2}";
    }
    @Override
    public final AmbiguousResolutionException injectionPointHasAmbiguousDependencies(final Object param1, final Object param2, final Object param3) {
        final AmbiguousResolutionException result = new AmbiguousResolutionException(_formatMessage(injectionPointHasAmbiguousDependencies$str(), param1, param2, param3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToConfigureInjectionTargetFactory$str() {
        return "WELD-001336: InjectionTargetFactory.configure() may not be called after createInjectionTarget() invocation. AnnotatedType used: {0}";
    }
    @Override
    public final IllegalStateException unableToConfigureInjectionTargetFactory(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unableToConfigureInjectionTargetFactory$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
