/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.ImplJAnnotation;
import org.jboss.jdeparser.JAnnotation;
import org.jboss.jdeparser.JAnnotationArray;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;
import org.jboss.jdeparser.Writable;

class ImplJAnnotationArray
implements JAnnotationArray,
Writable {
    private final JType type;
    private ArrayList<ImplJAnnotation> list;

    ImplJAnnotationArray(JType type) {
        this.type = type;
    }

    @Override
    public JAnnotation add() {
        ArrayList<ImplJAnnotation> list = this.list;
        if (list == null) {
            this.list = new ArrayList();
            list = this.list;
        }
        ImplJAnnotation annotation = new ImplJAnnotation(this.type);
        list.add(annotation);
        return annotation;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        writer.write(Tokens$.PUNCT.BRACE.OPEN);
        if (this.size() > 0) {
            writer.pushIndent(FormatPreferences.Indentation.LINE);
            try {
                writer.write(FormatPreferences.Space.WITHIN_BRACES_ARRAY_INIT);
                this.writeBare(writer);
            }
            finally {
                writer.popIndent(FormatPreferences.Indentation.LINE);
            }
            writer.write(FormatPreferences.Space.WITHIN_BRACES_ARRAY_INIT);
        }
        writer.write(Tokens$.PUNCT.BRACE.CLOSE);
    }

    int size() {
        ArrayList<ImplJAnnotation> list = this.list;
        return list == null ? 0 : list.size();
    }

    void writeBare(SourceFileWriter writer) throws IOException {
        Iterator<ImplJAnnotation> iterator;
        ArrayList<ImplJAnnotation> list = this.list;
        if (list != null && (iterator = list.iterator()).hasNext()) {
            iterator.next().write(writer);
            while (iterator.hasNext()) {
                writer.write(FormatPreferences.Space.BEFORE_COMMA);
                writer.write(Tokens$.PUNCT.COMMA);
                writer.write(FormatPreferences.Space.AFTER_COMMA);
                iterator.next().write(writer);
            }
        }
    }
}

