/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.DefaultBeanArchiveScanner;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.environment.servlet.util.Servlets;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.collections.ImmutableList;

public class WebAppBeanArchiveScanner
extends DefaultBeanArchiveScanner {
    static final String WEB_INF = "/WEB-INF";
    static final String WEB_INF_CLASSES = "/WEB-INF/classes";
    static final String WEB_INF_BEANS_XML = "/WEB-INF/beans.xml";
    static final String WEB_INF_CLASSES_BEANS_XML = "/WEB-INF/classes/META-INF/beans.xml";
    static final String WEB_INF_CLASSES_FILE_PATH = File.separatorChar + "WEB-INF" + File.separatorChar + "classes";
    static final String[] RESOURCES = new String[]{"/WEB-INF/beans.xml", "/WEB-INF/classes/META-INF/beans.xml"};
    private final ServletContext servletContext;

    public WebAppBeanArchiveScanner(ResourceLoader resourceLoader, Bootstrap bootstrap, ServletContext servletContext, BeanDiscoveryMode emptyBeansXmlDiscoveryMode) {
        super(resourceLoader, bootstrap, emptyBeansXmlDiscoveryMode);
        this.servletContext = servletContext;
    }

    @Override
    public List<BeanArchiveScanner.ScanResult> scan() {
        String contextPath = this.servletContext.getContextPath();
        ArrayList<BeanArchiveScanner.ScanResult> results = new ArrayList<BeanArchiveScanner.ScanResult>(super.scan());
        File webInfClasses = null;
        BeanArchiveScanner.ScanResult webInfBeansXML = null;
        try {
            BeansXml beansXml;
            URL beansXmlUrl = null;
            for (String resource : RESOURCES) {
                URL resourceUrl = this.servletContext.getResource(resource);
                if (resourceUrl == null) continue;
                if (beansXmlUrl != null) {
                    WeldServletLogger.LOG.foundBothConfiguration(beansXmlUrl);
                    continue;
                }
                beansXmlUrl = resourceUrl;
            }
            if (beansXmlUrl != null && this.accept(beansXml = this.parseBeansXml(beansXmlUrl))) {
                webInfClasses = Servlets.getRealFile(this.servletContext, WEB_INF_CLASSES);
                webInfBeansXML = webInfClasses != null ? new BeanArchiveScanner.ScanResult(beansXml, webInfClasses.getPath()).extractBeanArchiveId(contextPath, WEB_INF) : new BeanArchiveScanner.ScanResult(beansXml, WEB_INF_CLASSES);
            }
        }
        catch (MalformedURLException e) {
            throw WeldServletLogger.LOG.errorLoadingResources(e);
        }
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            BeanArchiveScanner.ScanResult result = (BeanArchiveScanner.ScanResult)iterator.next();
            String path = result.getBeanArchiveRef().toString();
            if (path.contains(WEB_INF_CLASSES_FILE_PATH) || path.contains(WEB_INF_CLASSES) || new File(path).equals(webInfClasses)) {
                iterator.remove();
                continue;
            }
            result.extractBeanArchiveId(contextPath, WEB_INF);
        }
        if (webInfBeansXML != null) {
            results.add(webInfBeansXML);
        }
        return ImmutableList.copyOf(results);
    }
}

