/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.interceptor.WeldInvocationContext;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.Primitives;
import org.jboss.weld.util.collections.ImmutableSet;

abstract class AbstractInvocationContext
implements WeldInvocationContext {
    protected Map<String, Object> contextData;
    protected final Method method;
    protected Object[] parameters;
    protected final Object target;
    protected final Object timer;
    protected final Constructor<?> constructor;
    protected final Set<Annotation> interceptorBindings;
    protected final Method proceed;
    private static final Map<Class<?>, Set<Class<?>>> WIDENING_TABLE;

    protected AbstractInvocationContext(Object target, Method method, Method proceed, Object[] parameters, Map<String, Object> contextData, Set<Annotation> interceptorBindings) {
        this(target, method, proceed, null, parameters, null, contextData, interceptorBindings);
    }

    protected AbstractInvocationContext(Object target, Method method, Method proceed, Constructor<?> constructor, Object[] parameters, Object timer, Map<String, Object> contextData, Set<Annotation> interceptorBindings) {
        this.target = target;
        this.method = method;
        this.proceed = proceed;
        this.constructor = constructor;
        this.parameters = parameters;
        this.timer = timer;
        this.contextData = contextData;
        this.interceptorBindings = interceptorBindings != null ? interceptorBindings : Collections.emptySet();
    }

    @Override
    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = AbstractInvocationContext.newContextData(this.interceptorBindings);
        }
        return this.contextData;
    }

    protected static Map<String, Object> newContextData(Set<Annotation> interceptorBindings) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("org.jboss.weld.interceptor.bindings", interceptorBindings);
        return result;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Object[] getParameters() {
        if (this.method != null || this.constructor != null) {
            return this.parameters;
        }
        throw new IllegalStateException("Illegal invocation to getParameters() during lifecycle invocation");
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    private static boolean isWideningPrimitive(Class<?> argumentClass, Class<?> targetClass) {
        return WIDENING_TABLE.containsKey(argumentClass) && WIDENING_TABLE.get(argumentClass).contains(targetClass);
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public void setParameters(Object[] params) {
        if (this.method != null || this.constructor != null) {
            int newParametersCount = params == null ? 0 : params.length;
            Class<?>[] parameterTypes = null;
            parameterTypes = this.method != null ? this.method.getParameterTypes() : this.constructor.getParameterTypes();
            if (parameterTypes.length != newParametersCount) {
                throw new IllegalArgumentException("Wrong number of parameters: method has " + parameterTypes.length + ", attempting to set " + newParametersCount + (params != null ? "" : " (argument was null)"));
            }
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    Class<?> methodParameterClass = parameterTypes[i];
                    if (params[i] != null) {
                        Class<?> newArgumentClass = params[i].getClass();
                        if (newArgumentClass.equals(methodParameterClass)) break;
                        if (newArgumentClass.isPrimitive()) {
                            if (methodParameterClass.isPrimitive()) {
                                if (AbstractInvocationContext.isWideningPrimitive(newArgumentClass, methodParameterClass)) continue;
                                this.throwIAE(i, methodParameterClass, newArgumentClass);
                                continue;
                            }
                            Class<?> boxedArgumentClass = Primitives.wrap(newArgumentClass);
                            if (methodParameterClass.isAssignableFrom(boxedArgumentClass)) continue;
                            this.throwIAE(i, methodParameterClass, newArgumentClass);
                            continue;
                        }
                        if (methodParameterClass.isPrimitive()) {
                            Class<?> unboxedClass = Primitives.unwrap(newArgumentClass);
                            if (unboxedClass.equals(methodParameterClass) || AbstractInvocationContext.isWideningPrimitive(unboxedClass, methodParameterClass)) continue;
                            this.throwIAE(i, methodParameterClass, newArgumentClass);
                            continue;
                        }
                        if (methodParameterClass.isAssignableFrom(newArgumentClass)) continue;
                        this.throwIAE(i, methodParameterClass, newArgumentClass);
                        continue;
                    }
                    if (!parameterTypes[i].isPrimitive()) continue;
                    throw new IllegalArgumentException("Trying to set a null value on a " + parameterTypes[i].getName());
                }
                this.parameters = params;
            }
        } else {
            throw new IllegalStateException("Illegal invocation to setParameters() during lifecycle invocation");
        }
    }

    private void throwIAE(int i, Class<?> methodParameterClass, Class<?> newArgumentClass) {
        throw new IllegalArgumentException("Incompatible parameter type on position: " + i + " :" + newArgumentClass + " (expected type was " + methodParameterClass.getName() + ")");
    }

    @Override
    public Object getTimer() {
        return this.timer;
    }

    @Override
    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    @Override
    public <T extends Annotation> Set<T> getInterceptorBindingsByType(Class<T> annotationType) {
        Preconditions.checkArgumentNotNull(annotationType, "annotationType");
        return (Set)this.interceptorBindings.stream().filter(annotation -> annotation.annotationType().equals(annotationType)).map(annotation -> annotation).collect(ImmutableSet.collector());
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindings;
    }

    protected Method getProceed() {
        return this.proceed;
    }

    static {
        HashMap<Class<Serializable>, Set<Class<Object>>> wideningTable = new HashMap<Class<Serializable>, Set<Class<Object>>>();
        wideningTable.put(Byte.TYPE, ImmutableSet.of(new Class[]{Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}));
        wideningTable.put(Short.TYPE, ImmutableSet.of(new Class[]{Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}));
        wideningTable.put(Character.TYPE, ImmutableSet.of(new Class[]{Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}));
        wideningTable.put(Integer.TYPE, ImmutableSet.of(new Class[]{Long.TYPE, Float.TYPE, Double.TYPE}));
        wideningTable.put(Long.TYPE, ImmutableSet.of(new Class[]{Float.TYPE, Double.TYPE}));
        wideningTable.put(Float.TYPE, Collections.singleton(Double.TYPE));
        WIDENING_TABLE = Collections.unmodifiableMap(wideningTable);
    }
}

