/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.config;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.weld.environment.servlet.test.config.GoodBean;
import org.jboss.weld.environment.servlet.test.config.dos.DOSBean;
import org.jboss.weld.environment.servlet.test.util.BeansXml;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigTestBase {
    @Inject
    private BeanManager beanManager;

    public static WebArchive baseDeployment(final Package ... excludedPackages) {
        BeansXml beansXml = new BeansXml(){

            protected void appendExternal(StringBuilder xml) {
                xml.append("<weld:scan>");
                for (Package pckg : excludedPackages) {
                    xml.append("<weld:exclude name=\"").append(pckg.getName()).append(".**\"/>");
                }
                xml.append("</weld:scan>");
            }
        };
        beansXml.setSchema("<beans xmlns=\"http://java.sun.com/xml/ns/javaee\" \n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n       xmlns:weld=\"http://jboss.org/schema/weld/beans\" \n       xsi:schemaLocation=\"\n          http://java.sun.com/xml/ns/javaee http://docs.jboss.org/cdi/beans_1_0.xsd\n          http://jboss.org/schema/weld/beans http://jboss.org/schema/weld/beans_1_1.xsd\">\n");
        return Deployments.baseDeployment(beansXml);
    }

    public static WebArchive baseDOSDeployment() {
        return (WebArchive)ConfigTestBase.baseDeployment(DOSBean.class.getPackage()).addClasses(new Class[]{ConfigTestBase.class, GoodBean.class, DOSBean.class});
    }

    protected void assertBeans(Class<?> beanClass, int size) {
        Assert.assertNotNull((String)"Null bean manager", (Object)this.beanManager);
        Set beans = this.beanManager.getBeans(beanClass, new Annotation[0]);
        Assert.assertEquals((long)size, (long)beans.size());
    }

    @Test
    public void testDOS() throws Exception {
        this.assertBeans(GoodBean.class, 1);
        this.assertBeans(DOSBean.class, 0);
    }
}

