/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.crosscontext;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.IOException;
import java.net.URL;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.weld.environment.servlet.test.crosscontext.ForwardingServlet;
import org.jboss.weld.environment.servlet.test.crosscontext.IncludedServlet;
import org.jboss.weld.environment.servlet.test.util.BeansXml;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.junit.Assert;
import org.junit.Test;

public class CrossContextForwardTestBase {
    public static final Asset FORWARDING_WEB_XML = new ByteArrayAsset(Deployments.extendDefaultWebXml("<servlet><servlet-name>Forwarding Servlet</servlet-name><servlet-class>" + ForwardingServlet.class.getName() + "</servlet-class></servlet> <servlet-mapping><servlet-name>Forwarding Servlet</servlet-name><url-pattern>/forwarding</url-pattern></servlet-mapping>").getBytes());
    public static final Asset INCLUDED_WEB_XML = new ByteArrayAsset(Deployments.extendDefaultWebXml("<servlet><servlet-name>Included Servlet</servlet-name><servlet-class>" + IncludedServlet.class.getName() + "</servlet-class></servlet> <servlet-mapping><servlet-name>Included Servlet</servlet-name><url-pattern>/included</url-pattern></servlet-mapping>").getBytes());
    protected static final String FIRST = "first";
    protected static final String SECOND = "second";

    public static WebArchive createFirstTestArchive() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"app1.war")).addAsWebInfResource((Asset)new BeansXml(), "beans.xml")).setWebXML(FORWARDING_WEB_XML);
        war.addClass(ForwardingServlet.class);
        return war;
    }

    public static WebArchive createSecondTestArchive() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"app2.war")).addAsWebInfResource((Asset)new BeansXml(), "beans.xml")).setWebXML(INCLUDED_WEB_XML);
        war.addClass(IncludedServlet.class);
        return war;
    }

    @Test
    public void testCrossContextForward(@ArquillianResource @OperateOnDeployment(value="first") URL firstContext) throws IOException {
        Page page = new WebClient().getPage(firstContext + "forwarding");
        Assert.assertEquals((long)200L, (long)page.getWebResponse().getStatusCode());
        Assert.assertEquals((Object)"<h1>Hello World</h1>", (Object)page.getWebResponse().getContentAsString());
    }
}

