/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.context.async;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.weld.environment.servlet.test.context.async.AsyncRequestProcessor;
import org.jboss.weld.environment.servlet.test.context.async.AsyncServlet;
import org.jboss.weld.environment.servlet.test.context.async.FailingServlet;
import org.jboss.weld.environment.servlet.test.context.async.SimpleAsyncListener;
import org.jboss.weld.environment.servlet.test.context.async.StatusServlet;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SimpleAsyncListenerTestBase {
    @ArquillianResource
    private URL contextPath;

    public static WebArchive deployment() {
        return (WebArchive)Deployments.baseDeployment().addClasses(new Class[]{SimpleAsyncListenerTestBase.class, FailingServlet.class, StatusServlet.class, AsyncServlet.class, AsyncRequestProcessor.class, SimpleAsyncListener.class});
    }

    @Test
    public void testOnCompleteCalledSuccesfully() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.getPath("complete"));
        Page results = webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getWebResponse().getContentAsString().contains("onComplete: true"));
    }

    @Test
    public void testOnTimeoutCalledSuccesfully() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(false);
        webClient.getPage(this.getPath("timeout"));
        Page results = webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getWebResponse().getContentAsString().contains("onTimeout: true"));
    }

    @Test
    @Ignore
    public void testOnErrorCalledSuccesfully() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(false);
        webClient.getPage(this.getPath("error"));
        Page results = webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getWebResponse().getContentAsString().contains("onError: true"));
    }

    @Test
    public void testOnStartAsyncCalledSuccesfully() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.getPath("loop"));
        Page results = webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getWebResponse().getContentAsString().contains("onComplete: true"));
        Assert.assertTrue((boolean)results.getWebResponse().getContentAsString().contains("onStartAsync: true"));
    }

    private String getPath(String test) {
        return this.contextPath + "AsyncServlet?test=" + test;
    }
}

