/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.discovery;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.weld.environment.servlet.test.discovery.Cat;
import org.jboss.weld.environment.servlet.test.discovery.Cow;
import org.jboss.weld.environment.servlet.test.discovery.Dog;
import org.jboss.weld.environment.servlet.test.discovery.Flat;
import org.jboss.weld.environment.servlet.test.discovery.House;
import org.jboss.weld.environment.servlet.test.discovery.Plant;
import org.jboss.weld.environment.servlet.test.discovery.Stone;
import org.jboss.weld.environment.servlet.test.discovery.Tree;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.junit.Assert;
import org.junit.Test;

public class BeanDiscoveryInjectionTestBase {
    protected static WebArchive baseTestArchive() {
        WebArchive testArchive = (WebArchive)Deployments.baseDeployment().addClass(BeanDiscoveryInjectionTestBase.class);
        JavaArchive archive01 = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.ALL), "beans.xml")).addClasses(new Class[]{Dog.class, Cat.class, Cow.class});
        JavaArchive archive02 = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.ANNOTATED), "beans.xml")).addClasses(new Class[]{Plant.class, Tree.class, Stone.class});
        JavaArchive archive03 = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.NONE), "beans.xml")).addClasses(new Class[]{Flat.class, House.class});
        testArchive.addAsLibraries(new Archive[]{archive01, archive02, archive03});
        return testArchive;
    }

    @Test
    public void testAllBeanDiscovery(BeanManager manager) {
        Assert.assertEquals((long)1L, (long)manager.getBeans(Dog.class, new Annotation[0]).size());
        Assert.assertEquals((long)1L, (long)manager.getBeans(Cat.class, new Annotation[0]).size());
        Assert.assertEquals((long)1L, (long)manager.getBeans(Cow.class, new Annotation[0]).size());
    }

    @Test
    public void testAnnotatedBeanDiscovery(BeanManager manager) {
        Assert.assertEquals((long)1L, (long)manager.getBeans(Tree.class, new Annotation[0]).size());
        Assert.assertEquals((long)1L, (long)manager.getBeans(Plant.class, new Annotation[0]).size());
        Assert.assertEquals((long)0L, (long)manager.getBeans(Stone.class, new Annotation[0]).size());
    }

    @Test
    public void testNoneBeanDiscovery(BeanManager manager) {
        Assert.assertEquals((long)0L, (long)manager.getBeans(Flat.class, new Annotation[0]).size());
        Assert.assertEquals((long)0L, (long)manager.getBeans(House.class, new Annotation[0]).size());
    }
}

