/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.config;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.weld.environment.servlet.test.config.GoodBean;
import org.jboss.weld.environment.servlet.test.config.dos.DOSBean;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.junit.Assert;
import org.junit.Test;

public abstract class ConfigTestBase {
    @Inject
    private BeanManager beanManager;

    public static WebArchive baseDeployment(Package ... excludedPackages) {
        BeansXml beansXml = new BeansXml();
        ArrayList<BeansXml.Exclude> filters = new ArrayList<BeansXml.Exclude>();
        for (Package pckg : excludedPackages) {
            filters.add(BeansXml.Exclude.match((String)(pckg.getName() + ".**")));
        }
        beansXml.excludeFilters(filters.toArray(new BeansXml.Exclude[filters.size()]));
        return Deployments.baseDeployment(beansXml);
    }

    protected void assertBeans(Class<?> beanClass, int size) {
        Assert.assertNotNull((String)"Null bean manager", (Object)this.beanManager);
        Set beans = this.beanManager.getBeans(beanClass, new Annotation[0]);
        Assert.assertEquals((long)size, (long)beans.size());
    }

    @Test
    public void testDOS() throws Exception {
        this.assertBeans(GoodBean.class, 1);
        this.assertBeans(DOSBean.class, 0);
    }
}

