/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.discovery.alternatives;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.BeanArchive;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.weld.environment.servlet.test.discovery.Cat;
import org.jboss.weld.environment.servlet.test.discovery.Dog;
import org.jboss.weld.environment.servlet.test.discovery.DogInterface;
import org.jboss.weld.environment.servlet.test.discovery.Flat;
import org.jboss.weld.environment.servlet.test.discovery.Plant;
import org.jboss.weld.environment.servlet.test.discovery.Stone;
import org.jboss.weld.environment.servlet.test.discovery.Tree;
import org.jboss.weld.environment.servlet.test.discovery.alternatives.AlternativeDog;
import org.jboss.weld.environment.servlet.test.discovery.alternatives.AlternativeFlat;
import org.jboss.weld.environment.servlet.test.discovery.alternatives.AlternativeStone;
import org.jboss.weld.environment.servlet.test.discovery.alternatives.AlternativeTree;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class AlternativeDiscoveryTest {
    @Deployment
    public static WebArchive createTestArchive() {
        WebArchive testArchive = (WebArchive)Deployments.baseDeployment().addClass(AlternativeDiscoveryTest.class);
        JavaArchive archive01 = (JavaArchive)((JavaArchive)((BeanArchive)ShrinkWrap.create(BeanArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.ALL).alternatives(new Class[]{AlternativeDog.class}), "beans.xml")).addClasses(new Class[]{Dog.class, AlternativeDog.class, DogInterface.class, Cat.class});
        JavaArchive archive02 = (JavaArchive)((JavaArchive)((BeanArchive)ShrinkWrap.create(BeanArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.ANNOTATED).alternatives(new Class[]{AlternativeTree.class}), "beans.xml")).addClasses(new Class[]{Tree.class, AlternativeTree.class, Plant.class, Stone.class, AlternativeStone.class});
        JavaArchive archive03 = (JavaArchive)((JavaArchive)((BeanArchive)ShrinkWrap.create(BeanArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.NONE).alternatives(new Class[]{AlternativeFlat.class}), "beans.xml")).addClasses(new Class[]{Flat.class, AlternativeFlat.class});
        testArchive.addAsLibraries(new Archive[]{archive01, archive02, archive03});
        return testArchive;
    }

    @Test
    public void testAllBeanDiscoveryAlternative(Cat representative) {
        BeanManager bm = representative.getBeanManager();
        Set beans = bm.getBeans(DogInterface.class, new Annotation[0]);
        Assert.assertEquals((long)2L, (long)beans.size());
        Assert.assertEquals(AlternativeDog.class, (Object)bm.resolve(beans).getBeanClass());
    }

    @Test
    public void testAnnotatedBeanDiscoveryAlternative(Plant representative) {
        BeanManager bm = representative.getBeanManager();
        Set treeBeans = bm.getBeans(Tree.class, new Annotation[0]);
        Assert.assertEquals((long)2L, (long)treeBeans.size());
        Assert.assertEquals(AlternativeTree.class, (Object)bm.resolve(treeBeans).getBeanClass());
        Set stoneBeans = bm.getBeans(Stone.class, new Annotation[0]);
        Assert.assertEquals((long)0L, (long)stoneBeans.size());
    }

    @Test
    public void testNoneBeanDiscoveryAlternative(Flat flat) {
        Assert.assertNull((Object)flat);
    }
}

