/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.discovery.decorators;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.BeanArchive;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.weld.environment.servlet.test.discovery.Cat;
import org.jboss.weld.environment.servlet.test.discovery.Dog;
import org.jboss.weld.environment.servlet.test.discovery.Flat;
import org.jboss.weld.environment.servlet.test.discovery.House;
import org.jboss.weld.environment.servlet.test.discovery.Plant;
import org.jboss.weld.environment.servlet.test.discovery.Tree;
import org.jboss.weld.environment.servlet.test.discovery.decorators.ClassicDecorator;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.junit.Assert;
import org.junit.Test;

public class DecoratorDiscoveryTestBase {
    public static WebArchive baseTestArchive() {
        WebArchive testArchive = (WebArchive)Deployments.baseDeployment().addClass(DecoratorDiscoveryTestBase.class);
        JavaArchive archive01 = (JavaArchive)((JavaArchive)((BeanArchive)ShrinkWrap.create(BeanArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.ALL).decorators(new Class[]{ClassicDecorator.class}), "beans.xml")).addClasses(new Class[]{Dog.class, Cat.class});
        JavaArchive archive02 = (JavaArchive)((JavaArchive)((BeanArchive)ShrinkWrap.create(BeanArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.ANNOTATED).decorators(new Class[]{ClassicDecorator.class}), "beans.xml")).addClasses(new Class[]{Plant.class, Tree.class, ClassicDecorator.class});
        JavaArchive archive03 = (JavaArchive)((JavaArchive)((BeanArchive)ShrinkWrap.create(BeanArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.NONE).decorators(new Class[]{ClassicDecorator.class}), "beans.xml")).addClasses(new Class[]{Flat.class, House.class});
        testArchive.addAsLibraries(new Archive[]{archive01, archive02, archive03});
        return testArchive;
    }

    @Test
    public void testAllBeanDiscovery(Cat cat, Dog dog) {
        ClassicDecorator.reset();
        cat.methodToBeDecorated();
        Assert.assertEquals((long)1L, (long)ClassicDecorator.called);
        dog.methodToBeDecorated();
        Assert.assertEquals((long)1L, (long)ClassicDecorator.called);
    }

    @Test
    public void testAnnotatedBeanDiscovery(Plant plant, Tree tree) {
        ClassicDecorator.reset();
        plant.methodToBeDecorated();
        Assert.assertEquals((long)1L, (long)ClassicDecorator.called);
        tree.methodToBeDecorated();
        Assert.assertEquals((long)1L, (long)ClassicDecorator.called);
    }
}

