/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.injection;

import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.weld.environment.servlet.test.injection.BatListener;
import org.jboss.weld.environment.servlet.test.injection.BatRequestListener;
import org.jboss.weld.environment.servlet.test.injection.BatServlet;
import org.jboss.weld.environment.servlet.test.injection.BatServletContextListener;
import org.jboss.weld.environment.servlet.test.injection.BatSessionListener;
import org.jboss.weld.environment.servlet.test.injection.Sewer;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.junit.Assert;
import org.junit.Test;

public class ListenerInjectionTestBase {
    public static WebArchive deployment() {
        StringBuilder listeners = new StringBuilder();
        listeners.append(Deployments.toListener(BatRequestListener.class.getName()));
        listeners.append(Deployments.toListener(BatSessionListener.class.getName()));
        listeners.append(Deployments.toListener(BatServletContextListener.class.getName()));
        ByteArrayAsset webXml = new ByteArrayAsset(Deployments.extendDefaultWebXml(listeners.toString() + "<servlet><servlet-name>Bat Servlet</servlet-name><servlet-class>" + BatServlet.class.getName() + "</servlet-class></servlet> <servlet-mapping><servlet-name>Bat Servlet</servlet-name><url-pattern>/bat</url-pattern></servlet-mapping>").getBytes());
        return (WebArchive)Deployments.baseDeployment((Asset)webXml).addClasses(new Class[]{BatRequestListener.class, BatSessionListener.class, BatServletContextListener.class, BatListener.class, BatServlet.class, Sewer.class});
    }

    @Test
    public void testRequestListenerInjection(@ArquillianResource URL baseURL) throws Exception {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(new URL(baseURL, "bat?mode=request").toExternalForm());
        int sc = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)sc);
    }

    @Test
    public void testSceListenerInjection(@ArquillianResource URL baseURL) throws Exception {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(new URL(baseURL, "bat?mode=sce").toExternalForm());
        int sc = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)sc);
    }

    @Test
    public void testSessionListenerInjection(@ArquillianResource URL baseURL) throws Exception {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(new URL(baseURL, "bat?mode=session").toExternalForm());
        int sc = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)sc);
    }
}

