/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.isolation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.BeanArchive;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.weld.environment.servlet.test.isolation.Camera;
import org.jboss.weld.environment.servlet.test.isolation.CameraDecorator;
import org.jboss.weld.environment.servlet.test.isolation.DSLR;
import org.jboss.weld.environment.servlet.test.isolation.PinholeCamera;
import org.jboss.weld.environment.servlet.test.isolation.RangefinderCamera;
import org.jboss.weld.environment.servlet.test.isolation.Zoom;
import org.jboss.weld.environment.servlet.test.isolation.ZoomInterceptor;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class IsolationDisabledTest {
    @Deployment
    public static WebArchive createTestArchive() {
        WebArchive testArchive = (WebArchive)Deployments.baseDeployment((Asset)new StringAsset(Deployments.extendDefaultWebXml(Deployments.toContextParam("org.jboss.weld.environment.servlet.archive.isolation", "false")))).addClass(IsolationDisabledTest.class);
        JavaArchive archive01 = (JavaArchive)((JavaArchive)((BeanArchive)ShrinkWrap.create(BeanArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.ALL).interceptors(new Class[]{ZoomInterceptor.class}).decorators(new Class[]{CameraDecorator.class}).alternatives(new Class[]{RangefinderCamera.class}).excludeFilters(new BeansXml.Exclude[]{BeansXml.Exclude.exact(PinholeCamera.class).ifClassAvailable(DSLR.class)}), "beans.xml")).addClasses(new Class[]{ZoomInterceptor.class, CameraDecorator.class, RangefinderCamera.class});
        JavaArchive archive02 = (JavaArchive)((JavaArchive)((BeanArchive)ShrinkWrap.create(BeanArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.ALL), "beans.xml")).addClasses(new Class[]{Zoom.class, Camera.class, DSLR.class, PinholeCamera.class});
        testArchive.addAsLibraries(new Archive[]{archive01, archive02});
        return testArchive;
    }

    @After
    public void resetInvocations() {
        CameraDecorator.invocations = 0;
        ZoomInterceptor.invocations = 0;
    }

    @Test
    public void testInterceptorAndDecorator01(DSLR camera) {
        camera.capture();
        Assert.assertEquals((long)1L, (long)CameraDecorator.invocations);
        Assert.assertEquals((long)1L, (long)ZoomInterceptor.invocations);
    }

    @Test
    public void testInterceptorAndDecorator02(RangefinderCamera camera) {
        camera.capture();
        Assert.assertEquals((long)1L, (long)CameraDecorator.invocations);
        Assert.assertEquals((long)0L, (long)ZoomInterceptor.invocations);
    }

    @Test
    public void testAlternative(BeanManager bm) {
        Set<Class<?>> cameras = this.getBeanClasses(bm, (Type)((Object)Camera.class), new Annotation[0]);
        Assert.assertTrue((boolean)cameras.contains(DSLR.class));
        Assert.assertTrue((boolean)cameras.contains(RangefinderCamera.class));
        Assert.assertEquals((long)2L, (long)cameras.size());
    }

    @Test
    public void testExcludeFilters(BeanManager bm) {
        Assert.assertFalse((boolean)this.getBeanClasses(bm, (Type)((Object)Camera.class), new Annotation[0]).contains(PinholeCamera.class));
    }

    private Set<Class<?>> getBeanClasses(BeanManager bm, Type beanType, Annotation ... annotations) {
        HashSet classes = new HashSet();
        for (Bean bean : bm.getBeans(beanType, annotations)) {
            classes.add(bean.getBeanClass());
        }
        return classes;
    }
}

