/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.discovery.interceptors;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.BeanArchive;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.weld.environment.servlet.test.discovery.Cat;
import org.jboss.weld.environment.servlet.test.discovery.Dog;
import org.jboss.weld.environment.servlet.test.discovery.Flat;
import org.jboss.weld.environment.servlet.test.discovery.House;
import org.jboss.weld.environment.servlet.test.discovery.InterceptorBindingAnnotation;
import org.jboss.weld.environment.servlet.test.discovery.Plant;
import org.jboss.weld.environment.servlet.test.discovery.Stone;
import org.jboss.weld.environment.servlet.test.discovery.Tree;
import org.jboss.weld.environment.servlet.test.discovery.interceptors.ClassicInterceptor;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.junit.Assert;
import org.junit.Test;

public class InterceptorDiscoveryTestBase {
    public static WebArchive baseTestArchive() {
        WebArchive testArchive = (WebArchive)Deployments.baseDeployment().addClass(InterceptorDiscoveryTestBase.class);
        JavaArchive archive01 = (JavaArchive)((JavaArchive)((BeanArchive)ShrinkWrap.create(BeanArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.ALL).interceptors(new Class[]{ClassicInterceptor.class}), "beans.xml")).addClasses(new Class[]{Dog.class, Cat.class, InterceptorBindingAnnotation.class});
        JavaArchive archive02 = (JavaArchive)((JavaArchive)((BeanArchive)ShrinkWrap.create(BeanArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.ANNOTATED).interceptors(new Class[]{ClassicInterceptor.class}), "beans.xml")).addClasses(new Class[]{Plant.class, Tree.class, Stone.class, ClassicInterceptor.class});
        JavaArchive archive03 = (JavaArchive)((JavaArchive)((BeanArchive)ShrinkWrap.create(BeanArchive.class)).addAsManifestResource((Asset)new BeansXml(BeanDiscoveryMode.NONE).interceptors(new Class[]{ClassicInterceptor.class}), "beans.xml")).addClasses(new Class[]{Flat.class, House.class});
        testArchive.addAsLibraries(new Archive[]{archive01, archive02, archive03});
        return testArchive;
    }

    @Test
    public void testAllBeanDiscovery(Dog dog) {
        ClassicInterceptor.reset();
        dog.bark();
        Assert.assertEquals((long)1L, (long)ClassicInterceptor.called);
    }

    @Test
    public void testAnnotatedBeanDiscovery(Plant plant, Tree tree) {
        ClassicInterceptor.reset();
        plant.getHeigh();
        Assert.assertEquals((long)1L, (long)ClassicInterceptor.called);
        tree.grow();
        Assert.assertEquals((long)1L, (long)ClassicInterceptor.called);
    }
}

