/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.interceptor.InvocationContext;
import org.jboss.interceptor.InterceptorException;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.model.InterceptorClassMetadata;
import org.jboss.interceptor.proxy.InterceptionHandler;
import org.jboss.interceptor.registry.InterceptorClassMetadataRegistry;
import org.jboss.interceptor.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassInterceptionHandler
implements InterceptionHandler,
Serializable {
    private InterceptorClassMetadata interceptorMetadata;
    private Class<?> clazz;

    public abstract Object getInterceptorInstance();

    protected AbstractClassInterceptionHandler(Class<?> clazz) {
        this.clazz = clazz;
        this.interceptorMetadata = InterceptorClassMetadataRegistry.getRegistry().getInterceptorClassMetadata(this.clazz);
    }

    @Override
    public Object invoke(Object target, InterceptionType interceptionType, InvocationContext invocationContext) throws Exception {
        List<Method> methods = this.interceptorMetadata.getInterceptorMethods(interceptionType);
        if (methods != null) {
            DelegatingInvocationContext delegatingInvocationContext = new DelegatingInvocationContext(invocationContext, this.getInterceptorInstance(), methods);
            return delegatingInvocationContext.proceed();
        }
        throw new InterceptorException(target.toString() + " was requested to perform " + interceptionType.name() + " but no such method is defined on it");
    }

    public InterceptorClassMetadata getInterceptorMetadata() {
        return this.interceptorMetadata;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public boolean handles(Class<?> clazz) {
        return this.clazz.equals(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DelegatingInvocationContext
    implements InvocationContext {
        private InvocationContext delegateInvocationContext;
        private Object targetObject;
        private Queue<Method> invocationQueue;

        public DelegatingInvocationContext(InvocationContext delegateInvocationContext, Object targetObject, List<Method> methods) {
            this.delegateInvocationContext = delegateInvocationContext;
            this.targetObject = targetObject;
            this.invocationQueue = new ConcurrentLinkedQueue<Method>(methods);
        }

        @Override
        public Map<String, Object> getContextData() {
            return this.delegateInvocationContext.getContextData();
        }

        @Override
        public Method getMethod() {
            return this.delegateInvocationContext.getMethod();
        }

        @Override
        public Object[] getParameters() {
            return this.delegateInvocationContext.getParameters();
        }

        @Override
        public Object getTarget() {
            return this.delegateInvocationContext.getTarget();
        }

        @Override
        public Object proceed() throws Exception {
            if (!this.invocationQueue.isEmpty()) {
                Method interceptorMethod = this.invocationQueue.remove();
                ReflectionUtils.ensureAccessible(interceptorMethod);
                try {
                    if (interceptorMethod.getParameterTypes().length == 0) {
                        return interceptorMethod.invoke(this.targetObject, new Object[0]);
                    }
                    return interceptorMethod.invoke(this.targetObject, this);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof Exception) {
                        throw (Exception)e.getCause();
                    }
                    throw new InterceptorException(e);
                }
            }
            return this.delegateInvocationContext.proceed();
        }

        @Override
        public void setParameters(Object[] params) {
            this.delegateInvocationContext.setParameters(params);
        }

        @Override
        public Object getTimer() {
            return this.delegateInvocationContext.getTimer();
        }
    }
}

