/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.jboss.interceptor.InterceptorException;
import org.jboss.interceptor.proxy.InterceptionChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorInvocationContext
implements InvocationContext {
    private Map<String, Object> contextData = new HashMap<String, Object>();
    private Method method;
    private Object[] parameters;
    private Object target;
    private InterceptionChain interceptionChain;
    private Object timer;

    public InterceptorInvocationContext(InterceptionChain interceptionChain, Object target, Method targetMethod, Object[] parameters) {
        this.interceptionChain = interceptionChain;
        this.method = targetMethod;
        this.parameters = parameters;
        this.target = target;
        this.timer = null;
    }

    public InterceptorInvocationContext(InterceptionChain interceptionChain, Object target, Method targetMethod, Object timer) {
        this.interceptionChain = interceptionChain;
        this.method = targetMethod;
        this.timer = timer;
        this.target = target;
        this.parameters = null;
    }

    @Override
    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public Object proceed() throws Exception {
        try {
            return this.interceptionChain.invokeNext(this);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new InterceptorException(t);
        }
    }

    @Override
    public void setParameters(Object[] params) {
        if (this.method != null) {
            this.parameters = params;
        }
    }

    @Override
    public Object getTimer() {
        return this.timer;
    }
}

