/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.weld.environment.servlet.deployment.AbstractScanner;
import org.jboss.weld.environment.servlet.deployment.WebAppBeanDeploymentArchive;
import org.jboss.weld.log.Log;
import org.jboss.weld.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLScanner
extends AbstractScanner {
    private static final Log log = Logging.getLog(URLScanner.class);

    public URLScanner(ClassLoader classLoader, WebAppBeanDeploymentArchive webBeanDiscovery) {
        super(classLoader, webBeanDiscovery);
    }

    @Override
    public void scanDirectories(File[] directories) {
        for (File directory : directories) {
            this.handleDirectory(directory, null);
        }
    }

    @Override
    public void scanResources(String[] resources) {
        HashSet<String> paths = new HashSet<String>();
        for (String resourceName : resources) {
            try {
                Enumeration<URL> urlEnum = this.getClassLoader().getResources(resourceName);
                while (urlEnum.hasMoreElements()) {
                    String urlPath = urlEnum.nextElement().getFile();
                    if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                    if (urlPath.indexOf(33) > 0) {
                        urlPath = urlPath.substring(0, urlPath.indexOf(33));
                    } else {
                        File dirOrArchive = new File(urlPath);
                        if (resourceName != null && resourceName.lastIndexOf(47) > 0) {
                            dirOrArchive = dirOrArchive.getParentFile();
                        }
                        urlPath = dirOrArchive.getParent();
                    }
                    paths.add(urlPath);
                }
            }
            catch (IOException ioe) {
                log.warn((Object)("could not read: " + resourceName), ioe, new Object[0]);
            }
        }
        this.handle(paths);
    }

    protected void handle(Set<String> paths) {
        for (String urlPath : paths) {
            try {
                log.trace((Object)("scanning: " + urlPath), new Object[0]);
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.handleDirectory(file, null);
                    continue;
                }
                this.handleArchiveByFile(file);
            }
            catch (IOException ioe) {
                log.warn((Object)"could not read entries", ioe, new Object[0]);
            }
        }
    }

    private void handleArchiveByFile(File file) throws IOException {
        try {
            log.trace((Object)("archive: " + file), new Object[0]);
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                this.handle(name, this.getClassLoader().getResource(name));
            }
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    private void handleDirectory(File file, String path) {
        this.handleDirectory(file, path, new File[0]);
    }

    private void handleDirectory(File file, String path, File[] excludedDirectories) {
        for (File excludedDirectory : excludedDirectories) {
            if (!file.equals(excludedDirectory)) continue;
            log.trace((Object)("skipping excluded directory: " + file), new Object[0]);
            return;
        }
        log.trace((Object)("handling directory: " + file), new Object[0]);
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath, excludedDirectories);
                continue;
            }
            try {
                this.handle(newPath, child.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.error((Object)("Error loading file " + newPath), new Object[0]);
            }
        }
    }
}

