/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.environment.servlet.util.Servlets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppBeanDeploymentArchive
implements BeanDeploymentArchive {
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    public static final String WEB_INF_BEANS_XML = "/WEB-INF/beans.xml";
    public static final String WEB_INF_CLASSES = "/WEB-INF/classes";
    private final Set<Class<?>> classes = new HashSet();
    private final Set<URL> beansXml = new HashSet<URL>();
    private final ServiceRegistry services = new SimpleServiceRegistry();

    public WebAppBeanDeploymentArchive(ServletContext servletContext) {
        this.scan(servletContext);
    }

    public Iterable<Class<?>> discoverWeldClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    public Iterable<URL> discoverWeldXml() {
        return Collections.unmodifiableSet(this.beansXml);
    }

    public Set<URL> getWeldUrls() {
        return this.beansXml;
    }

    private void scan(ServletContext servletContext) {
        URLScanner scanner = new URLScanner(Reflections.getClassLoader(), this);
        scanner.scanResources(new String[]{META_INF_BEANS_XML});
        try {
            URL beans = servletContext.getResource(WEB_INF_BEANS_XML);
            if (beans != null) {
                this.beansXml.add(beans);
                File webInfClasses = Servlets.getRealFile(servletContext, WEB_INF_CLASSES);
                if (webInfClasses != null) {
                    File[] files = new File[]{webInfClasses};
                    scanner.scanDirectories(files);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Error loading resources from servlet context ", e);
        }
    }

    @Override
    public Collection<Class<?>> getBeanClasses() {
        return this.classes;
    }

    @Override
    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.emptySet();
    }

    @Override
    public Collection<URL> getBeansXml() {
        return this.beansXml;
    }

    @Override
    public Collection<EjbDescriptor<?>> getEjbs() {
        return Collections.emptySet();
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public String getId() {
        return "web-module";
    }
}

