/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.log;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import java.util.Arrays;
import org.jboss.weld.log.Log;
import org.jboss.weld.log.LogProvider;
import org.jboss.weld.log.Logging;

class LogImpl
implements Log,
Externalizable {
    private transient LogProvider log;
    private String category;

    public LogImpl() {
    }

    LogImpl(String category) {
        this.category = category;
        this.log = Logging.getLogProvider(category, true);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void trace(Object object, Object ... params) {
        if (this.isTraceEnabled()) {
            this.log.trace(this.interpolate(object, params));
        }
    }

    public void trace(Object object, Throwable t, Object ... params) {
        if (this.isTraceEnabled()) {
            this.log.trace(this.interpolate(object, params), t);
        }
    }

    public void debug(Object object, Object ... params) {
        if (this.isDebugEnabled()) {
            this.log.debug(this.interpolate(object, params));
        }
    }

    public void debug(Object object, Throwable t, Object ... params) {
        if (this.isDebugEnabled()) {
            this.log.debug(this.interpolate(object, params), t);
        }
    }

    public void info(Object object, Object ... params) {
        if (this.isInfoEnabled()) {
            this.log.info(this.interpolate(object, params));
        }
    }

    public void info(Object object, Throwable t, Object ... params) {
        if (this.isInfoEnabled()) {
            this.log.info(this.interpolate(object, params), t);
        }
    }

    public void warn(Object object, Object ... params) {
        if (this.isWarnEnabled()) {
            this.log.warn(this.interpolate(object, params));
        }
    }

    public void warn(Object object, Throwable t, Object ... params) {
        if (this.isWarnEnabled()) {
            this.log.warn(this.interpolate(object, params), t);
        }
    }

    public void error(Object object, Object ... params) {
        if (this.isErrorEnabled()) {
            this.log.error(this.interpolate(object, params));
        }
    }

    public void error(Object object, Throwable t, Object ... params) {
        if (this.isErrorEnabled()) {
            this.log.error(this.interpolate(object, params), t);
        }
    }

    public void fatal(Object object, Object ... params) {
        if (this.isFatalEnabled()) {
            this.log.fatal(this.interpolate(object, params));
        }
    }

    public void fatal(Object object, Throwable t, Object ... params) {
        if (this.isFatalEnabled()) {
            this.log.fatal(this.interpolate(object, params), t);
        }
    }

    private Object interpolate(Object message, Object ... params) {
        Object interpolatedMessage = message;
        if (params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null || !params[i].getClass().isArray()) continue;
                params[i] = Arrays.asList((Object[])params[i]);
            }
            interpolatedMessage = MessageFormat.format(message.toString(), params);
        }
        return interpolatedMessage;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.category = (String)in.readObject();
        this.log = Logging.getLogProvider(this.category, true);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.category);
    }
}

