/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.reflection.SecureReflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyMethodHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = -5391564935097267888L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private transient Bean<?> bean;
    private final String id;
    private static final ThreadLocal<WeldCreationalContext<?>> currentCreationalContext = new ThreadLocal();

    public ClientProxyMethodHandler(Bean<?> bean, String id) {
        this.bean = bean;
        this.id = id;
        log.trace("Created method handler for bean " + bean + " identified as " + id);
    }

    @Override
    public Object invoke(Object self, Method proxiedMethod, Method proceed, Object[] args) throws Throwable {
        Object proxiedInstance;
        if (this.bean == null) {
            this.bean = (Bean)Container.instance().services().get(ContextualStore.class).getContextual(this.id);
        }
        if ((proxiedInstance = this.getProxiedInstance(this.bean)) == null) {
            return null;
        }
        if (proxiedMethod.getName().equals("equals") && proxiedMethod.getParameterTypes().length == 1 && proxiedMethod.getParameterTypes()[0] == Object.class && args[0] == self) {
            return true;
        }
        try {
            Method method = SecureReflections.lookupMethod(proxiedInstance, proxiedMethod);
            Object returnValue = SecureReflections.invoke(proxiedInstance, method, args);
            log.trace(BeanMessage.CALL_PROXIED_METHOD, proxiedMethod, proxiedInstance, args, returnValue == null ? null : returnValue);
            return returnValue;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getProxiedInstance(Bean<T> bean) {
        boolean outer;
        WeldCreationalContext<T> creationalContext;
        if (currentCreationalContext.get() == null) {
            creationalContext = new CreationalContextImpl<T>(bean);
            currentCreationalContext.set(creationalContext);
            outer = true;
        } else {
            creationalContext = currentCreationalContext.get().getCreationalContext(bean);
            outer = false;
        }
        try {
            Context context = Container.instance().deploymentManager().getContext(bean.getScope());
            Container.instance().services().get(CurrentInjectionPoint.class).pushDummy();
            T t = context.get(bean, creationalContext);
            return t;
        }
        finally {
            Container.instance().services().get(CurrentInjectionPoint.class).popDummy();
            if (outer) {
                currentCreationalContext.remove();
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String beanInfo = this.bean == null ? "null bean" : this.bean.toString();
        buffer.append("Proxy method handler for " + beanInfo + " with id " + this.id);
        return buffer.toString();
    }
}

