/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLScanner {
    private static final Logger log = LoggerFactory.getLogger(URLScanner.class);
    private final ClassLoader classLoader;

    public URLScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected void handle(String name, URL url, List<String> classes, List<URL> urls) {
        if (name.endsWith(".class")) {
            classes.add(URLScanner.filenameToClassname(name));
        } else if (name.equals("META-INF/beans.xml")) {
            urls.add(url);
        }
    }

    public void scanDirectories(File[] directories, List<String> classes, List<URL> urls) {
        for (File directory : directories) {
            this.handleDirectory(directory, null, classes, urls);
        }
    }

    public void scanResources(String[] resources, List<String> classes, List<URL> urls) {
        HashSet<String> paths = new HashSet<String>();
        for (String resourceName : resources) {
            try {
                Enumeration<URL> urlEnum = this.classLoader.getResources(resourceName);
                while (urlEnum.hasMoreElements()) {
                    String urlPath = urlEnum.nextElement().getFile();
                    if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                    if (urlPath.indexOf(33) > 0) {
                        urlPath = urlPath.substring(0, urlPath.indexOf(33));
                    } else {
                        File dirOrArchive = new File(urlPath);
                        if (resourceName != null && resourceName.lastIndexOf(47) > 0) {
                            dirOrArchive = dirOrArchive.getParentFile();
                        }
                        urlPath = dirOrArchive.getParent();
                    }
                    paths.add(urlPath);
                }
            }
            catch (IOException ioe) {
                log.warn("could not read: " + resourceName, ioe);
            }
        }
        this.handle(paths, classes, urls);
    }

    protected void handle(Set<String> paths, List<String> classes, List<URL> urls) {
        for (String urlPath : paths) {
            try {
                log.trace("scanning: " + urlPath);
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.handleDirectory(file, null, classes, urls);
                    continue;
                }
                this.handleArchiveByFile(file, classes, urls);
            }
            catch (IOException ioe) {
                log.warn("could not read entries", ioe);
            }
        }
    }

    private void handleArchiveByFile(File file, List<String> classes, List<URL> urls) throws IOException {
        try {
            log.trace("archive: " + file);
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                this.handle(name, this.classLoader.getResource(name), classes, urls);
            }
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    private void handleDirectory(File file, String path, List<String> classes, List<URL> urls) {
        this.handleDirectory(file, path, new File[0], classes, urls);
    }

    private void handleDirectory(File file, String path, File[] excludedDirectories, List<String> classes, List<URL> urls) {
        for (File excludedDirectory : excludedDirectories) {
            if (!file.equals(excludedDirectory)) continue;
            log.trace("skipping excluded directory: " + file);
            return;
        }
        log.trace("handling directory: " + file);
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath, excludedDirectories, classes, urls);
                continue;
            }
            try {
                this.handle(newPath, child.toURI().toURL(), classes, urls);
            }
            catch (MalformedURLException e) {
                log.error("Error loading file " + newPath);
            }
        }
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }
}

