/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.environment.servlet.util.Servlets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppBeanDeploymentArchive
implements BeanDeploymentArchive {
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    public static final String WEB_INF_BEANS_XML = "/WEB-INF/beans.xml";
    public static final String WEB_INF_CLASSES = "/WEB-INF/classes";
    private final List<String> classes;
    private final BeansXml beansXml;
    private final ServiceRegistry services = new SimpleServiceRegistry();

    public WebAppBeanDeploymentArchive(ServletContext servletContext, Bootstrap bootstrap) {
        this.classes = new ArrayList<String>();
        ArrayList<URL> urls = new ArrayList<URL>();
        URLScanner scanner = new URLScanner(Reflections.getClassLoader());
        scanner.scanResources(new String[]{META_INF_BEANS_XML}, this.classes, urls);
        try {
            URL beans = servletContext.getResource(WEB_INF_BEANS_XML);
            if (beans != null) {
                urls.add(beans);
                File webInfClasses = Servlets.getRealFile(servletContext, WEB_INF_CLASSES);
                if (webInfClasses != null) {
                    File[] files = new File[]{webInfClasses};
                    scanner.scanDirectories(files, this.classes, urls);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Error loading resources from servlet context ", e);
        }
        this.beansXml = bootstrap.parse(urls);
    }

    @Override
    public Collection<String> getBeanClasses() {
        return this.classes;
    }

    @Override
    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.emptySet();
    }

    @Override
    public BeansXml getBeansXml() {
        return this.beansXml;
    }

    @Override
    public Collection<EjbDescriptor<?>> getEjbs() {
        return Collections.emptySet();
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public String getId() {
        return "flat";
    }
}

