/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.jsf;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.jboss.weld.conversation.ConversationManager2;
import org.jboss.weld.jsf.JsfHelper;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.JsfMessage;
import org.jboss.weld.servlet.BeanProvider;
import org.slf4j.cal10n.LocLogger;

public class WeldPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.JSF);
    private ConversationManager2 conversationManager;

    private ConversationManager2 getConversationManager() {
        if (this.conversationManager == null) {
            this.conversationManager = BeanProvider.conversationManager(JsfHelper.getServletContext(FacesContext.getCurrentInstance()));
        }
        return this.conversationManager;
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            this.beforeRestoreView(phaseEvent.getFacesContext());
        }
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            this.afterRenderResponse(phaseEvent.getFacesContext());
        } else if (phaseEvent.getFacesContext().getResponseComplete()) {
            this.afterResponseComplete(phaseEvent.getFacesContext(), phaseEvent.getPhaseId());
        }
    }

    private void beforeRestoreView(FacesContext facesContext) {
        log.trace(JsfMessage.INITIATING_CONVERSATION, "Restore View");
    }

    private void afterRenderResponse(FacesContext facesContext) {
        log.trace(JsfMessage.CLEANING_UP_CONVERSATION, "Render Response", "response complete");
    }

    private void afterResponseComplete(FacesContext facesContext, PhaseId phaseId) {
        log.trace(JsfMessage.CLEANING_UP_CONVERSATION, phaseId, "the response has been marked complete");
    }

    private void initiateSessionAndConversation(FacesContext facesContext) {
        this.getConversationManager().setupConversation(JsfHelper.getConversationId(facesContext));
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

