/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.messages.ValidatorMessage;
import org.jboss.weld.manager.RemoveMetadataWrapperFunction;
import org.jboss.weld.metadata.MetadataImpl;
import org.jboss.weld.resources.spi.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enabled {
    public static final Enabled EMPTY_ENABLED = new Enabled(Collections.<Metadata<Class<Annotation>>>emptyList(), Collections.<Metadata<Class<?>>>emptyList(), Collections.<Metadata<Class<?>>>emptyList(), Collections.<Metadata<Class<?>>>emptyList());
    private final Map<Class<? extends Annotation>, Metadata<Class<? extends Annotation>>> alternativeStereotypes;
    private final Map<Class<?>, Metadata<Class<?>>> alternativeClasses;
    private final Map<Class<?>, Metadata<Class<?>>> decorators;
    private final Map<Class<?>, Metadata<Class<?>>> interceptors;
    private final Comparator<Decorator<?>> decoratorComparator;
    private final Comparator<Interceptor<?>> interceptorComparator;

    public static Enabled of(BeansXml beansXml, ResourceLoader resourceLoader) {
        if (beansXml == null) {
            return EMPTY_ENABLED;
        }
        ClassLoader classLoader = new ClassLoader(resourceLoader);
        ClassLoader annotationLoader = new ClassLoader(resourceLoader);
        return new Enabled(Lists.transform(beansXml.getEnabledAlternativeStereotypes(), annotationLoader), Lists.transform(beansXml.getEnabledAlternativeClasses(), classLoader), Lists.transform(beansXml.getEnabledDecorators(), classLoader), Lists.transform(beansXml.getEnabledInterceptors(), classLoader));
    }

    private Enabled(List<Metadata<Class<? extends Annotation>>> alternativeStereotypes, List<Metadata<Class<?>>> alternativeClasses, List<Metadata<Class<?>>> decorators, List<Metadata<Class<?>>> interceptors) {
        this.alternativeStereotypes = Enabled.createMetadataMap(alternativeStereotypes, ValidatorMessage.ALTERNATIVE_STEREOTYPE_SPECIFIED_MULTIPLE_TIMES);
        this.alternativeClasses = Enabled.createMetadataMap(alternativeClasses, ValidatorMessage.ALTERNATIVE_BEAN_CLASS_SPECIFIED_MULTIPLE_TIMES);
        this.decorators = Enabled.createMetadataMap(decorators, ValidatorMessage.DECORATOR_SPECIFIED_TWICE);
        this.interceptors = Enabled.createMetadataMap(interceptors, ValidatorMessage.INTERCEPTOR_SPECIFIED_TWICE);
        final List decoratorTypes = Lists.transform(decorators, new RemoveMetadataWrapperFunction());
        final List interceptorTypes = Lists.transform(interceptors, new RemoveMetadataWrapperFunction());
        this.decoratorComparator = new Comparator<Decorator<?>>(){

            @Override
            public int compare(Decorator<?> o1, Decorator<?> o2) {
                int p1 = decoratorTypes.indexOf(o1.getBeanClass());
                int p2 = decoratorTypes.indexOf(o2.getBeanClass());
                return p1 - p2;
            }
        };
        this.interceptorComparator = new Comparator<Interceptor<?>>(){

            @Override
            public int compare(Interceptor<?> o1, Interceptor<?> o2) {
                int p1 = interceptorTypes.indexOf(o1.getBeanClass());
                int p2 = interceptorTypes.indexOf(o2.getBeanClass());
                return p1 - p2;
            }
        };
    }

    private static <T> Map<T, Metadata<T>> createMetadataMap(List<Metadata<T>> metadata, ValidatorMessage specifiedTwiceMessage) {
        HashMap<T, Metadata<T>> result = new HashMap<T, Metadata<T>>();
        for (Metadata<T> value : metadata) {
            if (result.containsKey(value.getValue())) {
                throw new DeploymentException(specifiedTwiceMessage, metadata);
            }
            result.put(value.getValue(), value);
        }
        return result;
    }

    public Collection<Metadata<Class<? extends Annotation>>> getAlternativeStereotypes() {
        return Collections.unmodifiableCollection(this.alternativeStereotypes.values());
    }

    public Metadata<Class<? extends Annotation>> getAlternativeStereotype(Class<? extends Annotation> annotationType) {
        return this.alternativeStereotypes.get(annotationType);
    }

    public Collection<Metadata<Class<?>>> getAlternativeClasses() {
        return Collections.unmodifiableCollection(this.alternativeClasses.values());
    }

    public Metadata<Class<?>> getAlternativeClass(Class<?> clazz) {
        return this.alternativeClasses.get(clazz);
    }

    public Collection<Metadata<Class<?>>> getDecorators() {
        return Collections.unmodifiableCollection(this.decorators.values());
    }

    public Metadata<Class<?>> getDecorator(Class<?> clazz) {
        return this.decorators.get(clazz);
    }

    public Collection<Metadata<Class<?>>> getInterceptors() {
        return Collections.unmodifiableCollection(this.interceptors.values());
    }

    public Metadata<Class<?>> getInterceptor(Class<?> clazz) {
        return this.interceptors.get(clazz);
    }

    public Comparator<Decorator<?>> getDecoratorComparator() {
        return this.decoratorComparator;
    }

    public Comparator<Interceptor<?>> getInterceptorComparator() {
        return this.interceptorComparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassLoader<T>
    implements Function<Metadata<String>, Metadata<Class<? extends T>>> {
        private final ResourceLoader resourceLoader;

        public ClassLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        @Override
        public Metadata<Class<? extends T>> apply(Metadata<String> from) {
            return new MetadataImpl<Class<? extends T>>(this.resourceLoader.classForName(from.getValue()), from.getLocation());
        }
    }
}

