/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableArraySet<E>
implements Set<E>,
Serializable {
    private Object[] elements;

    public ImmutableArraySet(Collection<E> initialElements) {
        this.addElements(initialElements, initialElements.size());
    }

    public ImmutableArraySet(Collection<E> initialElements, E lastElement) {
        this.addElements(initialElements, initialElements.size() + 1);
        this.elements[initialElements.size()] = lastElement;
    }

    protected void addElements(Collection<E> otherSet, int desiredSize) {
        boolean realSet = otherSet instanceof Set;
        Iterator<E> setIterator = otherSet.iterator();
        int i = 0;
        this.elements = new Object[desiredSize];
        while (setIterator.hasNext()) {
            E element = setIterator.next();
            if (!realSet && this.contains(element)) continue;
            this.elements[i++] = element;
        }
        int reduceBy = otherSet.size() - i - 1;
        if (reduceBy > 0) {
            Object[] newElements = new Object[desiredSize - reduceBy];
            System.arraycopy(this.elements, 0, newElements, 0, desiredSize - reduceBy);
            this.elements = newElements;
        }
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.elements.length && this.elements[i] != null; ++i) {
            if (o != this.elements[i] && !o.equals(this.elements[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.elements == null ? true : this.elements.length == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new UnmodifiableIterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.elements == null ? 0 : this.elements.length;
    }

    @Override
    public Object[] toArray() {
        return this.elements == null ? new Object[]{} : (this.elements.length == 0 ? this.elements : Arrays.copyOf(this.elements, this.elements.length));
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int elementQuantity = this.size();
        if (a.length < elementQuantity) {
            return Arrays.copyOf(this.elements, this.elements.length, a.getClass());
        }
        if (elementQuantity > 0) {
            System.arraycopy(this.elements, 0, a, 0, elementQuantity);
        }
        for (int i = elementQuantity; i < a.length; ++i) {
            a[i] = null;
        }
        return a;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Set) {
            Object[] otherArray;
            int elementQuantity = this.size();
            if (elementQuantity != (otherArray = ((Set)obj).toArray()).length) {
                return false;
            }
            boolean arraysEqual = true;
            for (int i = 0; i < elementQuantity; ++i) {
                boolean objFound = false;
                for (int j = 0; j < otherArray.length; ++j) {
                    if (!this.elements[i].equals(otherArray[j])) continue;
                    objFound = true;
                    break;
                }
                if (objFound) continue;
                arraysEqual = false;
                break;
            }
            return arraysEqual;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    public String toString() {
        return Arrays.toString(this.elements);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UnmodifiableIterator
    implements Iterator<E> {
        private int currentElement = 0;

        UnmodifiableIterator() {
        }

        @Override
        public boolean hasNext() {
            return ImmutableArraySet.this.elements == null ? false : this.currentElement < ImmutableArraySet.this.elements.length;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ImmutableArraySet.this.elements[this.currentElement++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

