/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat, Inc. and/or its affiliates, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.weld.bean.proxy;

import java.lang.reflect.Method;

/**
 * Each proxy maintains a single bean instance on which methods
 * are invoked.  Different types of bean instances can also
 * be used to provide varying methods of obtaining the actual
 * instance from the container.
 * 
 * @author David Allen
 *
 */
public interface BeanInstance
{
   /**
    * Returns the current instance for a proxy.
    * 
    * @return the current bean instance
    */
   public Object getInstance();
   
   public Class<?> getInstanceType();
   
   public Object invoke(Object instance, Method method, Object... arguments) throws Throwable;
}
