/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import org.jboss.interceptor.proxy.InterceptorException;
import org.jboss.interceptor.proxy.InterceptorMethodHandler;
import org.jboss.interceptor.proxy.InterceptorProxyCreator;
import org.jboss.interceptor.proxy.javassist.CompositeHandler;
import org.jboss.interceptor.spi.context.InvocationContextFactory;
import org.jboss.interceptor.spi.instance.InterceptorInstantiator;
import org.jboss.interceptor.spi.metadata.ClassMetadata;
import org.jboss.interceptor.spi.model.InterceptionModel;
import org.jboss.interceptor.util.InterceptionUtils;
import sun.reflect.ReflectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorProxyCreatorImpl
implements InterceptorProxyCreator {
    private InvocationContextFactory invocationContextFactory;
    private InterceptionModel<ClassMetadata<?>, ?> interceptionModel;
    private InterceptorInstantiator<?, ?> interceptorInstantiator;

    public InterceptorProxyCreatorImpl(InterceptorInstantiator<?, ?> interceptorInstantiator, InvocationContextFactory invocationContextFactory, InterceptionModel<ClassMetadata<?>, ?> interceptionModel) {
        this.interceptorInstantiator = interceptorInstantiator;
        this.invocationContextFactory = invocationContextFactory;
        this.interceptionModel = interceptionModel;
    }

    public <T> T createSubclassingProxy(ClassMetadata<T> proxifiedClass, Class<?>[] constructorTypes, Object[] constructorArguments) {
        T instance = this.createAdvisedSubclassInstance(proxifiedClass, constructorTypes, constructorArguments);
        MethodHandler interceptorMethodHandler = this.createSubclassingMethodHandler(instance, proxifiedClass);
        ((ProxyObject)instance).setHandler(new CompositeHandler(Arrays.asList(interceptorMethodHandler)));
        return instance;
    }

    public <T> T createAdvisedSubclassInstance(ClassMetadata<T> proxifiedClass, Class<?>[] constructorParameterTypes, Object[] constructorArguments) {
        try {
            Class<T> clazz = InterceptionUtils.createProxyClass(proxifiedClass.getJavaClass(), true);
            Constructor<T> constructor = clazz.getConstructor(constructorParameterTypes);
            return constructor.newInstance(constructorArguments);
        }
        catch (Exception e) {
            throw new InterceptorException(e);
        }
    }

    public <T> T createProxyInstance(Class<T> proxyClass, MethodHandler interceptorMethodHandler) {
        Constructor<T> constructor = null;
        try {
            constructor = this.getNoArgConstructor(proxyClass);
            if (constructor == null) {
                constructor = this.getReflectionFactoryConstructor(proxyClass);
            }
        }
        catch (Exception e) {
            throw new InterceptorException(e);
        }
        if (constructor == null) {
            throw new InterceptorException("Cannot found a constructor for the proxy class: " + proxyClass + ". " + "No no-arg constructor is available, and sun.reflect.ReflectionFactory is not accessible");
        }
        try {
            T proxyObject = constructor.newInstance(new Object[0]);
            if (interceptorMethodHandler != null) {
                ((ProxyObject)proxyObject).setHandler(interceptorMethodHandler);
            }
            return proxyObject;
        }
        catch (Exception e) {
            throw new InterceptorException(e);
        }
    }

    @Override
    public <T> MethodHandler createMethodHandler(Object target, ClassMetadata<T> proxyClass) {
        return new InterceptorMethodHandler(target, proxyClass, this.interceptionModel, this.interceptorInstantiator, this.invocationContextFactory);
    }

    @Override
    public <T> MethodHandler createSubclassingMethodHandler(Object targetInstance, ClassMetadata<T> proxyClass) {
        return new InterceptorMethodHandler(targetInstance, proxyClass, this.interceptionModel, this.interceptorInstantiator, this.invocationContextFactory);
    }

    private <T> Constructor<T> getNoArgConstructor(Class<T> clazz) {
        Constructor<T> constructor;
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return constructor;
    }

    private <T> Constructor<T> getReflectionFactoryConstructor(Class<T> proxyClass) throws NoSuchMethodException {
        try {
            ReflectionFactory reflectionFactory = ReflectionFactory.getReflectionFactory();
            Constructor<?> constructor = reflectionFactory.newConstructorForSerialization(proxyClass, Object.class.getDeclaredConstructor(new Class[0]));
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }
}

