/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.interceptor.spi.model.InterceptionType;
import org.jboss.interceptor.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterceptionTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptionTypeRegistry.class);
    private static Map<InterceptionType, Class<? extends Annotation>> interceptionAnnotationClasses = new HashMap<InterceptionType, Class<? extends Annotation>>();

    public static Collection<InterceptionType> getSupportedInterceptionTypes() {
        return interceptionAnnotationClasses.keySet();
    }

    public static boolean isSupported(InterceptionType interceptionType) {
        return interceptionAnnotationClasses.containsKey((Object)interceptionType);
    }

    public static Class<? extends Annotation> getAnnotationClass(InterceptionType interceptionType) {
        return interceptionAnnotationClasses.get((Object)interceptionType);
    }

    static {
        for (InterceptionType interceptionType : InterceptionType.values()) {
            try {
                interceptionAnnotationClasses.put(interceptionType, ReflectionUtils.classForName(interceptionType.annotationClassName()));
            }
            catch (Exception e) {
                LOG.warn("Class '" + interceptionType.annotationClassName() + "' not found, interception based on it is not enabled");
            }
        }
    }
}

