/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import java.util.Arrays;
import java.util.ServiceLoader;
import javassist.util.proxy.ProxyFactory;
import javax.el.ELContextListener;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.environment.Container;
import org.jboss.weld.environment.ContainerContext;
import org.jboss.weld.environment.jetty.Jetty6Container;
import org.jboss.weld.environment.jetty.Jetty7Container;
import org.jboss.weld.environment.jetty.JettyPost72Container;
import org.jboss.weld.environment.servlet.deployment.ServletDeployment;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.jboss.weld.environment.servlet.deployment.VFSURLScanner;
import org.jboss.weld.environment.servlet.services.ServletResourceInjectionServices;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.environment.tomcat.Tomcat6Container;
import org.jboss.weld.environment.tomcat7.Tomcat7Container;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Listener
extends ForwardingServletListener {
    private static final Logger log = LoggerFactory.getLogger(Listener.class);
    private static final String BOOTSTRAP_IMPL_CLASS_NAME = "org.jboss.weld.bootstrap.WeldBootstrap";
    private static final String WELD_LISTENER_CLASS_NAME = "org.jboss.weld.servlet.WeldListener";
    private static final String EXPRESSION_FACTORY_NAME = "org.jboss.weld.el.ExpressionFactory";
    public static final String BEAN_MANAGER_ATTRIBUTE_NAME = Listener.class.getPackage().getName() + "." + BeanManager.class.getName();
    private final transient Bootstrap bootstrap;
    private final transient ServletListener weldListener;
    private Container container;

    public Listener() {
        try {
            this.bootstrap = (Bootstrap)Reflections.newInstance(BOOTSTRAP_IMPL_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error loading Weld bootstrap, check that Weld is on the classpath", e);
        }
        try {
            this.weldListener = (ServletListener)Reflections.newInstance(WELD_LISTENER_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error loading Weld listener, check that Weld is on the classpath", e);
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        this.bootstrap.shutdown();
        if (this.container != null) {
            this.container.destroy(new ContainerContext(sce, null));
        }
        super.contextDestroyed(sce);
    }

    protected ServletDeployment createServletDeployment(ServletContext context, Bootstrap bootstrap) {
        return new ServletDeployment(context, bootstrap);
    }

    protected URLScanner createUrlScanner(ClassLoader classLoader, ServletContext context) {
        try {
            classLoader.loadClass("org.jboss.virtual.VFS");
            return new VFSURLScanner(classLoader);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context;
        ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

            public ClassLoader get(ProxyFactory pf) {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        ClassLoader classLoader = Reflections.getClassLoader();
        URLScanner scanner = this.createUrlScanner(classLoader, context = sce.getServletContext());
        if (scanner != null) {
            context.setAttribute(URLScanner.class.getName(), (Object)scanner);
        }
        ServletDeployment deployment = this.createServletDeployment(context, this.bootstrap);
        try {
            deployment.getWebAppBeanDeploymentArchive().getServices().add(ResourceInjectionServices.class, new ServletResourceInjectionServices(){});
        }
        catch (NoClassDefFoundError e) {
            log.warn("@Resource injection not available in simple beans");
        }
        this.bootstrap.startContainer(Environments.SERVLET, deployment).startInitialization();
        WeldManager manager = this.bootstrap.getManager(deployment.getWebAppBeanDeploymentArchive());
        ContainerContext cc = new ContainerContext(sce, manager);
        StringBuilder dump = new StringBuilder();
        Container container = this.findContainer(cc, dump);
        if (container == null) {
            log.info("No supported servlet container detected, CDI injection will NOT be available in Servlets, Filtersor or Listeners");
            if (log.isDebugEnabled()) {
                log.debug("Exception dump from Container lookup: " + dump);
            }
        } else {
            container.initialize(cc);
            this.container = container;
        }
        context.setAttribute(BEAN_MANAGER_ATTRIBUTE_NAME, (Object)manager);
        if (JspFactory.getDefaultFactory() != null) {
            JspApplicationContext jspApplicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(context);
            jspApplicationContext.addELResolver(manager.getELResolver());
            jspApplicationContext.addELContextListener((ELContextListener)Reflections.newInstance("org.jboss.weld.el.WeldELContextListener"));
            context.setAttribute(EXPRESSION_FACTORY_NAME, (Object)manager.wrapExpressionFactory(jspApplicationContext.getExpressionFactory()));
        }
        this.bootstrap.deployBeans().validateBeans().endInitialization();
        super.contextInitialized(sce);
    }

    @Override
    protected ServletListener delegate() {
        return this.weldListener;
    }

    protected Container findContainer(ContainerContext cc, StringBuilder dump) {
        ServiceLoader<Container> extContainers = ServiceLoader.load(Container.class, this.getClass().getClassLoader());
        Container container = this.checkContainers(cc, dump, extContainers);
        if (container == null) {
            container = this.checkContainers(cc, dump, Arrays.asList(Tomcat7Container.INSTANCE, Tomcat6Container.INSTANCE, Jetty6Container.INSTANCE, JettyPost72Container.INSTANCE, Jetty7Container.INSTANCE));
        }
        return container;
    }

    protected Container checkContainers(ContainerContext cc, StringBuilder dump, Iterable<Container> containers) {
        for (Container c : containers) {
            try {
                if (!c.touch(cc)) continue;
                return c;
            }
            catch (Throwable t) {
                dump.append(c).append("->").append(t.getMessage()).append("\n");
            }
        }
        return null;
    }
}

