/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.MetadataMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.StereotypeModel;
import org.jboss.weld.util.collections.ArraySet;

public class MergedStereotypes<T, E> {
    private final ArraySet<Annotation> possibleScopeTypes = new ArraySet();
    private boolean beanNameDefaulted;
    private boolean alternative;
    private ArraySet<Class<? extends Annotation>> stereotypes = new ArraySet();
    private final BeanManagerImpl manager;

    public MergedStereotypes(Set<Annotation> stereotypeAnnotations, BeanManagerImpl manager) {
        this.manager = manager;
        this.merge(stereotypeAnnotations);
        this.possibleScopeTypes.trimToSize();
        this.stereotypes.trimToSize();
    }

    protected void merge(Set<Annotation> stereotypeAnnotations) {
        MetaAnnotationStore store = this.manager.getServices().get(MetaAnnotationStore.class);
        for (Annotation stereotypeAnnotation : stereotypeAnnotations) {
            StereotypeModel<? extends Annotation> stereotype = store.getStereotype(stereotypeAnnotation.annotationType());
            if (stereotype == null) {
                throw new IllegalStateException(MetadataMessage.STEREOTYPE_NOT_REGISTERED, stereotypeAnnotation);
            }
            if (stereotype.isAlternative()) {
                this.alternative = true;
            }
            if (stereotype.getDefaultScopeType() != null) {
                this.possibleScopeTypes.add(stereotype.getDefaultScopeType());
            }
            if (stereotype.isBeanNameDefaulted()) {
                this.beanNameDefaulted = true;
            }
            this.stereotypes.add(stereotypeAnnotation.annotationType());
            this.merge(stereotype.getInheritedSterotypes());
        }
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public Set<Annotation> getPossibleScopes() {
        return this.possibleScopeTypes;
    }

    public boolean isBeanNameDefaulted() {
        return this.beanNameDefaulted;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    public String toString() {
        return "Merged stereotype model; Any of the sterotypes is an alternative: " + this.alternative + "; possible scopes " + this.possibleScopeTypes;
    }
}

