/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import org.jboss.weld.bean.CommonBean;
import org.jboss.weld.bean.SyntheticClassBean;
import org.jboss.weld.injection.ForwardingInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;

public abstract class AbstractSyntheticBean<T>
extends CommonBean<T> {
    private final Class<?> beanClass;
    protected final Producer<T> producer;
    private final Set<InjectionPoint> injectionPoints;

    protected AbstractSyntheticBean(BeanAttributes<T> attributes, String id, BeanManagerImpl manager, Class<?> beanClass, Producer<T> producer) {
        super(attributes, id, manager);
        this.beanClass = beanClass;
        this.producer = producer;
        this.injectionPoints = this.wrapInjectionPoints(producer.getInjectionPoints());
    }

    protected static <T> String createId(BeanAttributes<T> attributes, Class<?> beanClass, Producer<T> producer) {
        return SyntheticClassBean.class.getName() + "-" + beanClass.getName() + Beans.createBeanAttributesId(attributes);
    }

    protected Set<InjectionPoint> wrapInjectionPoints(Set<InjectionPoint> injectionPoints) {
        HashSet<InjectionPoint> wrappedInjectionPoints = new HashSet<InjectionPoint>(injectionPoints.size());
        for (final InjectionPoint ip : injectionPoints) {
            wrappedInjectionPoints.add(new ForwardingInjectionPoint(){

                @Override
                public Bean<?> getBean() {
                    return AbstractSyntheticBean.this;
                }

                @Override
                protected InjectionPoint delegate() {
                    return ip;
                }
            });
        }
        return wrappedInjectionPoints;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    protected Producer<T> getProducer() {
        return this.producer;
    }
}

