/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.slf4j.cal10n.LocLogger;

@SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="bean field is loaded lazily")
public class ProxyMethodHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = 5293834510764991583L;
    protected static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private final BeanInstance beanInstance;
    private final String beanId;
    private transient Bean<?> bean;

    public ProxyMethodHandler(BeanInstance beanInstance, Bean<?> bean) {
        this.beanInstance = beanInstance;
        this.bean = bean;
        this.beanId = bean instanceof PassivationCapable ? ((PassivationCapable)((Object)bean)).getId() : null;
    }

    @Override
    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        boolean traceEnabled = log.isTraceEnabled();
        if (thisMethod == null) {
            if (traceEnabled) {
                log.trace("MethodHandler processing returning bean instance for " + self.getClass());
            }
            if (this.beanInstance == null) {
                throw new WeldException(BeanMessage.BEAN_INSTANCE_NOT_SET_ON_PROXY, new Object[0]);
            }
            return this.beanInstance.getInstance();
        }
        if (traceEnabled) {
            log.trace("MethodHandler processing call to " + thisMethod + " for " + self.getClass());
        }
        if (thisMethod.getDeclaringClass().equals(TargetInstanceProxy.class)) {
            if (this.beanInstance == null) {
                throw new WeldException(BeanMessage.BEAN_INSTANCE_NOT_SET_ON_PROXY, this.getBean());
            }
            if (thisMethod.getName().equals("getTargetInstance")) {
                return this.beanInstance.getInstance();
            }
            if (thisMethod.getName().equals("getTargetClass")) {
                return this.beanInstance.getInstanceType();
            }
            return null;
        }
        if (thisMethod.getName().equals("_initMH")) {
            if (traceEnabled) {
                log.trace("Setting new MethodHandler with bean instance for " + args[0] + " on " + self.getClass());
            }
            return new ProxyMethodHandler(new TargetBeanInstance(args[0]), this.getBean());
        }
        if (this.beanInstance == null) {
            throw new WeldException(BeanMessage.BEAN_INSTANCE_NOT_SET_ON_PROXY, new Object[0]);
        }
        Object instance = this.beanInstance.getInstance();
        Object result = this.beanInstance.invoke(instance, thisMethod, args);
        if (result != null && result == instance) {
            return self;
        }
        return result;
    }

    public Bean<?> getBean() {
        if (this.bean == null) {
            if (this.beanId == null) {
                throw new WeldException(BeanMessage.PROXY_HANDLER_SERIALIZED_FOR_NON_SERIALIZABLE_BEAN, new Object[0]);
            }
            this.bean = (Bean)Container.instance().services().get(ContextualStore.class).getContextual(this.beanId);
        }
        return this.bean;
    }
}

