/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.bootstrap.enablement.ClassEnablement;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.messages.ValidatorMessage;

public class ModuleEnablement {
    public static final ModuleEnablement EMPTY_ENABLEMENT = new ModuleEnablement(Collections.<ClassEnablement>emptyList(), Collections.<ClassEnablement>emptyList(), Collections.<ClassEnablement>emptyList());
    private final List<ClassEnablement> interceptors;
    private final List<ClassEnablement> decorators;
    private final List<ClassEnablement> alternatives;
    private final Map<String, Integer> interceptorMap;
    private final Map<String, Integer> decoratorMap;
    private final Map<String, ClassEnablement> alternativeMap;
    private final Comparator<Decorator<?>> decoratorComparator;
    private final Comparator<Interceptor<?>> interceptorComparator;

    public ModuleEnablement(List<ClassEnablement> interceptors, List<ClassEnablement> decorators, List<ClassEnablement> alternatives) {
        this.interceptors = interceptors;
        this.decorators = decorators;
        this.alternatives = alternatives;
        this.interceptorMap = ModuleEnablement.createLookupMap(interceptors, ValidatorMessage.INTERCEPTOR_SPECIFIED_TWICE);
        this.decoratorMap = ModuleEnablement.createLookupMap(decorators, ValidatorMessage.DECORATOR_SPECIFIED_TWICE);
        if (alternatives.isEmpty()) {
            this.alternativeMap = Collections.emptyMap();
        } else {
            HashMap<String, ClassEnablement> alternativeMap = new HashMap<String, ClassEnablement>();
            for (ClassEnablement alternative : alternatives) {
                alternativeMap.put(alternative.getEnabledClass().getName(), alternative);
            }
            this.alternativeMap = Collections.unmodifiableMap(alternativeMap);
        }
        this.decoratorComparator = new EnablementComparator(this.decoratorMap);
        this.interceptorComparator = new EnablementComparator(this.interceptorMap);
    }

    private static Map<String, Integer> createLookupMap(List<ClassEnablement> list, ValidatorMessage specifiedTwiceMessage) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            Integer previousOccurence = result.put(list.get(i).getEnabledClass().getName(), i);
            if (previousOccurence == null) continue;
            throw new DeploymentException(specifiedTwiceMessage, list.get(i).getEnabledClass().getName(), list.get(i), list.get(previousOccurence));
        }
        return Collections.unmodifiableMap(result);
    }

    public boolean isAlternativeEnabled(Class<?> javaClass) {
        return this.alternativeMap.containsKey(javaClass.getName());
    }

    public ClassEnablement getAlternative(Class<?> javaClass) {
        return this.alternativeMap.get(javaClass.getName());
    }

    public boolean isInterceptorEnabled(Class<?> javaClass) {
        return this.interceptorMap.containsKey(javaClass.getName());
    }

    public boolean isDecoratorEnabled(Class<?> javaClass) {
        return this.decoratorMap.containsKey(javaClass.getName());
    }

    public List<ClassEnablement> getInterceptors() {
        return this.interceptors;
    }

    public List<ClassEnablement> getDecorators() {
        return this.decorators;
    }

    public List<ClassEnablement> getAlternatives() {
        return this.alternatives;
    }

    public Comparator<Decorator<?>> getDecoratorComparator() {
        return this.decoratorComparator;
    }

    public Comparator<Interceptor<?>> getInterceptorComparator() {
        return this.interceptorComparator;
    }

    public String toString() {
        return "Enabled interceptors: " + this.interceptors + "\nEnabled decorators: " + this.decorators + "\nEnabled alternatives: " + this.alternatives;
    }

    private static class EnablementComparator<T extends Bean<?>>
    implements Comparator<T> {
        private final Map<String, Integer> enabledClasses;

        public EnablementComparator(Map<String, Integer> enabledClasses) {
            this.enabledClasses = enabledClasses;
        }

        @Override
        public int compare(T o1, T o2) {
            int p1 = this.enabledClasses.get(o1.getBeanClass().getName());
            int p2 = this.enabledClasses.get(o2.getBeanClass().getName());
            return p1 - p2;
        }
    }
}

