/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.interceptor.WeldInterceptorClassMetadata;
import org.jboss.weld.bean.interceptor.WeldInterceptorInstantiator;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.interceptor.proxy.DefaultInvocationContextFactory;
import org.jboss.weld.interceptor.proxy.InterceptorProxyCreatorImpl;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.manager.BeanManagerImpl;

public class InterceptorApplyingInstantiator<T>
implements Instantiator<T> {
    private final WeldInterceptorClassMetadata<T> weldInterceptorClassMetadata;
    private final InterceptionModel<ClassMetadata<?>, ?> interceptionModel;
    private final Instantiator<T> delegate;

    public InterceptorApplyingInstantiator(EnhancedAnnotatedType<T> type, Instantiator<T> delegate, BeanManagerImpl manager) {
        this.weldInterceptorClassMetadata = WeldInterceptorClassMetadata.of(type);
        this.interceptionModel = (InterceptionModel)manager.getInterceptorModelRegistry().get(type.getJavaClass());
        this.delegate = delegate;
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager) {
        T instance = this.delegate.newInstance(ctx, manager);
        this.applyInterceptors(instance, ctx, manager);
        return instance;
    }

    protected T applyInterceptors(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager) {
        try {
            WeldInterceptorInstantiator<T> interceptorInstantiator = new WeldInterceptorInstantiator<T>(manager, creationalContext);
            InterceptorProxyCreatorImpl interceptorProxyCreator = new InterceptorProxyCreatorImpl(interceptorInstantiator, new DefaultInvocationContextFactory(), this.interceptionModel);
            MethodHandler methodHandler = interceptorProxyCreator.createSubclassingMethodHandler(null, this.weldInterceptorClassMetadata);
            CombinedInterceptorAndDecoratorStackMethodHandler wrapperMethodHandler = (CombinedInterceptorAndDecoratorStackMethodHandler)((ProxyObject)instance).getHandler();
            wrapperMethodHandler.setInterceptorMethodHandler(methodHandler);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        return instance;
    }

    public String toString() {
        return "InterceptorApplyingInstantiator for " + this.delegate;
    }

    @Override
    public boolean hasInterceptorSupport() {
        return true;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return this.delegate.hasDecoratorSupport();
    }
}

