/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.ArraySetMultimap;
import org.jboss.weld.util.reflection.Reflections;

public class WeldCollections {
    public static final Map<Object, List<Object>> EMPTY_ARRAY_SET_MULTIMAP = Collections.unmodifiableMap(new ArraySetMultimap().trimToSize());

    private WeldCollections() {
    }

    public static <T> Set<T> immutableSet(Set<T> set) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        if (set instanceof ImmutableSet) {
            return set;
        }
        if (set instanceof ArraySet) {
            ((ArraySet)ArraySet.class.cast(set)).trimToSize();
        }
        return Collections.unmodifiableSet(set);
    }

    public static <T> List<T> immutableList(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list instanceof ImmutableList) {
            return list;
        }
        if (list instanceof ArrayList) {
            ((ArrayList)ArrayList.class.cast(list)).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        if (map.isEmpty()) {
            if (map instanceof ArraySetMultimap) {
                return (Map)Reflections.cast(EMPTY_ARRAY_SET_MULTIMAP);
            }
            return Collections.emptyMap();
        }
        if (map instanceof ImmutableMap) {
            return map;
        }
        if (map instanceof ArraySetMultimap) {
            ((ArraySetMultimap)ArraySetMultimap.class.cast(map)).trimToSize();
        }
        return Collections.unmodifiableMap(map);
    }
}

