/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.EnabledClass;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.metadata.BeansXmlImpl;
import org.jboss.weld.metadata.ScanningImpl;
import org.jboss.weld.xml.BeansXmlHandler;
import org.jboss.weld.xml.XmlSchema;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class BeansXmlParser {
    private static final InputSource[] EMPTY_INPUT_SOURCE_ARRAY = new InputSource[0];
    private static boolean disableValidating;

    public BeansXml parse(URL beansXml) {
        SAXParser parser;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(!disableValidating);
        factory.setNamespaceAware(true);
        if (beansXml == null) {
            throw new IllegalStateException(XmlMessage.LOAD_ERROR, "unknown");
        }
        try {
            parser = factory.newSAXParser();
        }
        catch (SAXException e) {
            throw new IllegalStateException(XmlMessage.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(XmlMessage.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
        }
        InputStream beansXmlInputStream = null;
        try {
            beansXmlInputStream = beansXml.openStream();
            InputSource source = new InputSource(beansXmlInputStream);
            if (source.getByteStream().available() == 0) {
                BeansXml beansXml2 = BeansXml.EMPTY_BEANS_XML;
                return beansXml2;
            }
            BeansXmlHandler handler = this.getHandler(beansXml);
            try {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", BeansXmlParser.loadXsds());
            }
            catch (IllegalArgumentException e) {
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
                // empty catch block
            }
            parser.parse(source, (DefaultHandler)handler);
            BeansXml beansXml3 = handler.createBeansXml();
            return beansXml3;
        }
        catch (IOException e) {
            throw new IllegalStateException(XmlMessage.LOAD_ERROR, (Throwable)e, beansXml);
        }
        catch (SAXException e) {
            throw new IllegalStateException(XmlMessage.PARSING_ERROR, (Throwable)e, beansXml);
        }
        finally {
            if (beansXmlInputStream != null) {
                try {
                    beansXmlInputStream.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    public BeansXml parse(Iterable<URL> urls) {
        return this.parse(urls, false);
    }

    public BeansXml parse(Iterable<URL> urls, boolean removeDuplicates) {
        ArrayList<Metadata<EnabledClass>> alternatives = new ArrayList<Metadata<EnabledClass>>();
        ArrayList<Metadata<EnabledClass>> decorators = new ArrayList<Metadata<EnabledClass>>();
        ArrayList<Metadata<EnabledClass>> interceptors = new ArrayList<Metadata<EnabledClass>>();
        ArrayList<Metadata<Filter>> includes = new ArrayList<Metadata<Filter>>();
        ArrayList<Metadata<Filter>> excludes = new ArrayList<Metadata<Filter>>();
        URL beansXmlUrl = null;
        for (URL url : urls) {
            BeansXml beansXml = this.parse(url);
            this.addTo(alternatives, beansXml.getEnabledAlternatives(), removeDuplicates);
            this.addTo(decorators, beansXml.getEnabledDecorators(), removeDuplicates);
            this.addTo(interceptors, beansXml.getEnabledInterceptors(), removeDuplicates);
            includes.addAll(beansXml.getScanning().getIncludes());
            excludes.addAll(beansXml.getScanning().getExcludes());
            beansXmlUrl = url;
        }
        return new BeansXmlImpl(alternatives, decorators, interceptors, new ScanningImpl(includes, excludes), beansXmlUrl);
    }

    private void addTo(List<Metadata<EnabledClass>> list, List<Metadata<EnabledClass>> listToAdd, boolean removeDuplicates) {
        if (removeDuplicates) {
            ArrayList<Metadata<EnabledClass>> filteredListToAdd = new ArrayList<Metadata<EnabledClass>>(listToAdd.size());
            for (Metadata<EnabledClass> metadata : listToAdd) {
                if (this.alreadyAdded(metadata, list)) continue;
                filteredListToAdd.add(metadata);
            }
            listToAdd = filteredListToAdd;
        }
        list.addAll(listToAdd);
    }

    private boolean alreadyAdded(Metadata<EnabledClass> metadata, List<Metadata<EnabledClass>> list) {
        for (Metadata<EnabledClass> existing : list) {
            if (!existing.getValue().equals(metadata.getValue())) continue;
            return true;
        }
        return false;
    }

    private static InputSource[] loadXsds() {
        ArrayList<InputSource> xsds = new ArrayList<InputSource>();
        for (XmlSchema schema : XmlSchema.values()) {
            InputSource source = BeansXmlParser.loadXsd(schema.getFileName(), schema.getClassLoader());
            if (source == null) continue;
            xsds.add(source);
        }
        return xsds.toArray(EMPTY_INPUT_SOURCE_ARRAY);
    }

    private static InputSource loadXsd(String name, ClassLoader classLoader) {
        InputStream in = classLoader.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        return new InputSource(in);
    }

    protected BeansXmlHandler getHandler(URL beansXml) {
        return new BeansXmlHandler(beansXml);
    }

    static {
        try {
            disableValidating = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("org.jboss.weld.xml.disableValidating");
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

